/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.map;

import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.apache.baremaps.cli.Options;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.tasks.ExportVectorTiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="export", description={"Export vector tiles from the database."})
public class Export
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(Export.class);
    @CommandLine.Mixin
    private Options options;
    @CommandLine.Option(names={"--tileset"}, paramLabel="TILESET", description={"The tileset file."}, required=true)
    private Path tileset;
    @CommandLine.Option(names={"--style"}, paramLabel="STYLE", description={"The style file."}, required=true)
    private Path style;
    @CommandLine.Option(names={"--repository"}, paramLabel="REPOSITORY", description={"The tile repository."}, required=true)
    private Path repository;
    @CommandLine.Option(names={"--tiles"}, paramLabel="TILES", description={"The tiles to export."})
    private URI tiles;
    @CommandLine.Option(names={"--format"}, paramLabel="FORMAT", description={"The format of the repository."})
    private ExportVectorTiles.Format format = ExportVectorTiles.Format.file;

    @Override
    public Integer call() throws Exception {
        new ExportVectorTiles(this.tileset.toAbsolutePath(), this.style.toAbsolutePath(), this.repository.toAbsolutePath(), this.format).execute(new WorkflowContext());
        return 0;
    }
}

