/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.cors;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.util.HttpTimestampSupplier;
import com.linecorp.armeria.internal.shaded.guava.base.Joiner;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.cors.CorsConfig;
import com.linecorp.armeria.server.cors.CorsPolicyBuilder;
import io.netty.util.AsciiString;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class CorsPolicy {
    private static final String DELIMITER = ",";
    private static final Joiner HEADER_JOINER = Joiner.on(",");
    private final Set<String> origins;
    private final List<Route> routes;
    private final boolean credentialsAllowed;
    private final boolean nullOriginAllowed;
    private final long maxAge;
    private final Set<AsciiString> exposedHeaders;
    private final Set<HttpMethod> allowedRequestMethods;
    private final boolean allowAllRequestHeaders;
    private final Set<AsciiString> allowedRequestHeaders;
    private final String joinedExposedHeaders;
    private final String joinedAllowedRequestHeaders;
    private final String joinedAllowedRequestMethods;
    private final Map<AsciiString, Supplier<?>> preflightResponseHeaders;

    public static CorsPolicyBuilder builder() {
        return new CorsPolicyBuilder();
    }

    public static CorsPolicyBuilder builder(String ... origins) {
        return new CorsPolicyBuilder(origins);
    }

    public static CorsPolicyBuilder builder(Iterable<String> origins) {
        return new CorsPolicyBuilder(origins);
    }

    CorsPolicy(Set<String> origins, List<Route> routes, boolean credentialsAllowed, long maxAge, boolean nullOriginAllowed, Set<AsciiString> exposedHeaders, boolean allowAllRequestHeaders, Set<AsciiString> allowedRequestHeaders, EnumSet<HttpMethod> allowedRequestMethods, boolean preflightResponseHeadersDisabled, Map<AsciiString, Supplier<?>> preflightResponseHeaders) {
        this.origins = ImmutableSet.copyOf(origins);
        this.routes = ImmutableList.copyOf(routes);
        this.credentialsAllowed = credentialsAllowed;
        this.maxAge = maxAge;
        this.nullOriginAllowed = nullOriginAllowed;
        this.exposedHeaders = ImmutableSet.copyOf(exposedHeaders);
        this.allowedRequestMethods = ImmutableSet.copyOf(allowedRequestMethods);
        this.allowAllRequestHeaders = allowAllRequestHeaders;
        this.allowedRequestHeaders = ImmutableSet.copyOf(allowedRequestHeaders);
        this.joinedExposedHeaders = HEADER_JOINER.join(this.exposedHeaders);
        this.joinedAllowedRequestMethods = this.allowedRequestMethods.stream().map(Enum::name).collect(Collectors.joining(DELIMITER));
        this.joinedAllowedRequestHeaders = HEADER_JOINER.join(this.allowedRequestHeaders);
        this.preflightResponseHeaders = preflightResponseHeadersDisabled ? Collections.emptyMap() : (preflightResponseHeaders.isEmpty() ? ImmutableMap.of(HttpHeaderNames.DATE, HttpTimestampSupplier::currentTime, HttpHeaderNames.CONTENT_LENGTH, CorsConfig.ConstantValueSupplier.ZERO) : ImmutableMap.copyOf(preflightResponseHeaders));
    }

    public String origin() {
        return Iterables.getFirst(this.origins, "*");
    }

    public Set<String> origins() {
        return this.origins;
    }

    public List<Route> routes() {
        return this.routes;
    }

    public boolean isCredentialsAllowed() {
        return this.credentialsAllowed;
    }

    public long maxAge() {
        return this.maxAge;
    }

    public Set<AsciiString> exposedHeaders() {
        return this.exposedHeaders;
    }

    public Set<HttpMethod> allowedRequestMethods() {
        return this.allowedRequestMethods;
    }

    public Set<AsciiString> allowedRequestHeaders() {
        return this.allowedRequestHeaders;
    }

    public boolean isNullOriginAllowed() {
        return this.nullOriginAllowed;
    }

    public HttpHeaders generatePreflightResponseHeaders() {
        HttpHeadersBuilder headers = HttpHeaders.builder();
        this.preflightResponseHeaders.forEach((key, value) -> {
            Object val = CorsPolicy.getValue(value);
            if (val instanceof Iterable) {
                headers.addObject((CharSequence)key, (Iterable)val);
            } else {
                headers.addObject((CharSequence)key, val);
            }
        });
        return headers.build();
    }

    void setCorsPreflightResponseHeaders(ResponseHeadersBuilder headers) {
        headers.add((Iterable)this.generatePreflightResponseHeaders());
    }

    void setCorsAllowCredentials(ResponseHeadersBuilder headers) {
        if (this.credentialsAllowed && !"*".equals(headers.get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN))) {
            headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        }
    }

    void setCorsExposeHeaders(ResponseHeadersBuilder headers) {
        if (this.exposedHeaders.isEmpty()) {
            return;
        }
        headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, this.joinedExposedHeaders);
    }

    void setCorsAllowMethods(ResponseHeadersBuilder headers) {
        headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, this.joinedAllowedRequestMethods);
    }

    void setCorsAllowHeaders(RequestHeaders requestHeaders, ResponseHeadersBuilder headers) {
        if (this.allowAllRequestHeaders) {
            this.copyCorsAllowHeaders(requestHeaders, headers);
            return;
        }
        if (this.allowedRequestHeaders.isEmpty()) {
            return;
        }
        headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, this.joinedAllowedRequestHeaders);
    }

    void setCorsMaxAge(ResponseHeadersBuilder headers) {
        headers.setLong((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE, this.maxAge);
    }

    private void copyCorsAllowHeaders(RequestHeaders requestHeaders, ResponseHeadersBuilder headers) {
        String header = requestHeaders.get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_HEADERS);
        if (Strings.isNullOrEmpty(header)) {
            return;
        }
        headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, header);
    }

    public String toString() {
        return CorsPolicy.toString(this, this.origins, this.routes, this.nullOriginAllowed, this.credentialsAllowed, this.maxAge, this.exposedHeaders, this.allowedRequestMethods, this.allowAllRequestHeaders, this.allowedRequestHeaders, this.preflightResponseHeaders);
    }

    static String toString(Object obj, @Nullable Set<String> origins, List<Route> routes, boolean nullOriginAllowed, boolean credentialsAllowed, long maxAge, @Nullable Set<AsciiString> exposedHeaders, @Nullable Set<HttpMethod> allowedRequestMethods, boolean allowAllRequestHeaders, @Nullable Set<AsciiString> allowedRequestHeaders, @Nullable Map<AsciiString, Supplier<?>> preflightResponseHeaders) {
        return MoreObjects.toStringHelper(obj).omitNullValues().add("origins", origins).add("routes", routes).add("nullOriginAllowed", nullOriginAllowed).add("credentialsAllowed", credentialsAllowed).add("maxAge", maxAge).add("exposedHeaders", exposedHeaders).add("allowedRequestMethods", allowedRequestMethods).add("allowAllRequestHeaders", allowAllRequestHeaders).add("allowedRequestHeaders", allowedRequestHeaders).add("preflightResponseHeaders", preflightResponseHeaders).toString();
    }

    private static <T> T getValue(Supplier<T> callable) {
        try {
            return callable.get();
        }
        catch (Exception e) {
            throw new IllegalStateException("could not generate value for supplier: " + callable, e);
        }
    }
}

