/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.AbstractPathMapping;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.RoutePathType;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.RoutingResult;
import com.linecorp.armeria.server.RoutingResultBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ParameterizedPathMapping
extends AbstractPathMapping {
    private static final Pattern VALID_PATTERN = Pattern.compile("(/[^/{}:]+|/:[^/{}]+|/\\{[^/{}]+})+/?");
    private static final Pattern CAPTURE_REST_PATTERN = Pattern.compile("/\\{\\*([^/{}]*)}|/:\\*([^/{}]*)");
    private static final Pattern CAPTURE_REST_VARIABLE_NAME_PATTERN = Pattern.compile("^\\w+$");
    private static final String[] EMPTY_NAMES = new String[0];
    private static final Splitter PATH_SPLITTER = Splitter.on('/');
    private final String prefix;
    private final String pathPattern;
    private final String normalizedPathPattern;
    private final Pattern pattern;
    private final String skeleton;
    private final List<String> paths;
    private final String[] paramNameArray;
    private final Set<String> paramNames;

    ParameterizedPathMapping(String pathPattern) {
        this("", pathPattern);
    }

    private ParameterizedPathMapping(String prefix, String pathPattern) {
        if (!Flags.allowSemicolonInPathComponent()) {
            Preconditions.checkArgument(prefix.indexOf(59) < 0, "prefix: %s (expected not to have a ';')", (Object)prefix);
            Preconditions.checkArgument(pathPattern.indexOf(59) < 0, "pathPattern: %s (expected not to have a ';')", (Object)pathPattern);
        }
        this.prefix = prefix;
        Objects.requireNonNull(pathPattern, "pathPattern");
        if (!pathPattern.startsWith("/")) {
            throw new IllegalArgumentException("pathPattern: " + pathPattern + " (must start with '/')");
        }
        if (!VALID_PATTERN.matcher(pathPattern).matches()) {
            throw new IllegalArgumentException("pathPattern: " + pathPattern + " (invalid pattern)");
        }
        if (!ParameterizedPathMapping.isValidCaptureRestPattern(pathPattern)) {
            throw new IllegalArgumentException("pathPattern: " + pathPattern + " (invalid capture rest pattern)");
        }
        StringJoiner patternJoiner = new StringJoiner("/");
        StringJoiner normalizedPatternJoiner = new StringJoiner("/");
        StringJoiner skeletonJoiner = new StringJoiner("/");
        ArrayList<String> paramNames = new ArrayList<String>();
        for (String token : PATH_SPLITTER.split(pathPattern)) {
            String paramName = ParameterizedPathMapping.paramName(token);
            if (paramName == null) {
                patternJoiner.add(token);
                normalizedPatternJoiner.add(token);
                skeletonJoiner.add(token);
                continue;
            }
            boolean captureRestPathMatching = ParameterizedPathMapping.isCaptureRestPathMatching(token);
            int paramNameIdx = paramNames.indexOf(paramName);
            if (paramNameIdx < 0) {
                paramNames.add(paramName);
                if (captureRestPathMatching) {
                    patternJoiner.add("(.*)");
                } else {
                    patternJoiner.add("([^/]+)");
                }
            } else {
                patternJoiner.add("\\" + (paramNameIdx + 1));
            }
            normalizedPatternJoiner.add((captureRestPathMatching ? ":*" : Character.valueOf(':')) + paramName);
            skeletonJoiner.add(captureRestPathMatching ? "*" : ":");
        }
        this.pathPattern = pathPattern;
        this.pattern = Pattern.compile(patternJoiner.toString());
        this.normalizedPathPattern = normalizedPatternJoiner.toString();
        this.skeleton = skeletonJoiner.toString();
        this.paths = ImmutableList.of(this.skeleton, this.skeleton);
        this.paramNameArray = paramNames.toArray(EMPTY_NAMES);
        this.paramNames = ImmutableSet.copyOf(paramNames);
    }

    @Nullable
    private static String paramName(String token) {
        if (token.startsWith("{") && token.endsWith("}")) {
            int beginIndex = token.charAt(1) == '*' ? 2 : 1;
            return token.substring(beginIndex, token.length() - 1);
        }
        if (token.startsWith(":")) {
            int beginIndex = token.charAt(1) == '*' ? 2 : 1;
            return token.substring(beginIndex);
        }
        return null;
    }

    private static boolean isCaptureRestPathMatching(String token) {
        return token.startsWith("{*") && token.endsWith("}") || token.startsWith(":*");
    }

    private static boolean isValidCaptureRestPattern(String pathPattern) {
        Matcher matcher = CAPTURE_REST_PATTERN.matcher(pathPattern);
        if (!matcher.find()) {
            return true;
        }
        String paramName = MoreObjects.firstNonNull(matcher.group(1), matcher.group(2));
        if (!CAPTURE_REST_VARIABLE_NAME_PATTERN.matcher(paramName).matches()) {
            return false;
        }
        return pathPattern.length() == matcher.end();
    }

    String skeleton() {
        return this.skeleton;
    }

    @Override
    PathMapping doWithPrefix(String prefix) {
        return new ParameterizedPathMapping(prefix, ArmeriaHttpUtil.concatPaths(prefix, this.pathPattern));
    }

    @Override
    public Set<String> paramNames() {
        return this.paramNames;
    }

    @Override
    public String patternString() {
        return this.normalizedPathPattern;
    }

    @Override
    public RoutePathType pathType() {
        return RoutePathType.PARAMETERIZED;
    }

    @Override
    public List<String> paths() {
        return this.paths;
    }

    @Override
    @Nullable
    RoutingResultBuilder doApply(RoutingContext routingCtx) {
        Matcher matcher = this.pattern.matcher(routingCtx.path());
        if (!matcher.matches()) {
            return null;
        }
        RoutingResultBuilder builder = RoutingResult.builderWithExpectedNumParams(this.paramNameArray.length).path(ParameterizedPathMapping.mappedPath(this.prefix, routingCtx.path())).query(routingCtx.query());
        for (int i = 0; i < this.paramNameArray.length; ++i) {
            builder.rawParam(this.paramNameArray[i], matcher.group(i + 1));
        }
        return builder;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterizedPathMapping)) {
            return false;
        }
        ParameterizedPathMapping that = (ParameterizedPathMapping)o;
        return this.skeleton.equals(that.skeleton) && Arrays.equals(this.paramNameArray, that.paramNameArray);
    }

    public int hashCode() {
        return this.skeleton.hashCode() * 31 + Arrays.hashCode(this.paramNameArray);
    }

    @Override
    public String toString() {
        return this.pathPattern;
    }
}

