/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.util;

import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.util.Map;

public final class StringUtil {
    private static final int MAX_NUM = 1000;
    private static final int MIN_NUM = -1000;
    private static final String[] intToString = new String[2001];
    private static final Map<String, Boolean> stringToBoolean = ImmutableMap.builder().put("true", true).put("TRUE", true).put("1", true).put("false", false).put("FALSE", false).put("0", false).build();

    public static String toString(int num) {
        if (num >= -1000 && num <= 1000) {
            return intToString[num + 1000];
        }
        return Integer.toString(num);
    }

    public static String toString(long num) {
        if (num >= -1000L && num <= 1000L) {
            return intToString[(int)(num + 1000L)];
        }
        return Long.toString(num);
    }

    public static Boolean toBoolean(String s, boolean errorOnFailure) {
        Boolean result = stringToBoolean.get(s);
        if (result != null) {
            return result;
        }
        if (errorOnFailure) {
            throw new IllegalArgumentException("must be one of " + stringToBoolean.keySet() + ": " + s);
        }
        return null;
    }

    private StringUtil() {
    }

    static {
        for (int i = -1000; i <= 1000; ++i) {
            String str;
            StringUtil.intToString[i + 1000] = str = Integer.toString(i);
        }
    }
}

