/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ContextAwareExecutor;
import com.linecorp.armeria.common.DefaultContextAwareExecutorService;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

public interface ContextAwareExecutorService
extends ContextAwareExecutor,
ExecutorService {
    public static ContextAwareExecutorService of(RequestContext context, ExecutorService executor) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(executor, "executor");
        if (executor instanceof ContextAwareExecutorService) {
            RequestContextUtil.ensureSameCtx(context, (ContextAwareExecutorService)executor, ContextAwareExecutorService.class);
            return (ContextAwareExecutorService)executor;
        }
        return new DefaultContextAwareExecutorService(context, executor);
    }

    @Override
    public RequestContext context();

    @Override
    public ExecutorService withoutContext();
}

