/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.io.BufferedInputStream;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import javax.sql.DataSource;
import org.apache.baremaps.database.collection.DataMap;
import org.apache.baremaps.openstreetmap.function.ChangeEntitiesHandler;
import org.apache.baremaps.openstreetmap.function.EntityProjectionTransformer;
import org.apache.baremaps.openstreetmap.function.NodeGeometryBuilder;
import org.apache.baremaps.openstreetmap.function.RelationMultiPolygonBuilder;
import org.apache.baremaps.openstreetmap.function.WayGeometryBuilder;
import org.apache.baremaps.openstreetmap.model.Change;
import org.apache.baremaps.openstreetmap.model.Header;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.State;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.openstreetmap.postgres.PostgresCoordinateMap;
import org.apache.baremaps.openstreetmap.postgres.PostgresHeaderRepository;
import org.apache.baremaps.openstreetmap.postgres.PostgresNodeRepository;
import org.apache.baremaps.openstreetmap.postgres.PostgresReferenceMap;
import org.apache.baremaps.openstreetmap.postgres.PostgresRelationRepository;
import org.apache.baremaps.openstreetmap.postgres.PostgresWayRepository;
import org.apache.baremaps.openstreetmap.repository.ChangeElementsImporter;
import org.apache.baremaps.openstreetmap.repository.HeaderRepository;
import org.apache.baremaps.openstreetmap.repository.Repository;
import org.apache.baremaps.openstreetmap.state.StateReader;
import org.apache.baremaps.openstreetmap.xml.XmlChangeReader;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateOsmDatabase
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(UpdateOsmDatabase.class);
    private Object database;
    private Integer databaseSrid;
    private String replicationUrl;

    public UpdateOsmDatabase() {
    }

    public UpdateOsmDatabase(Object database, Integer databaseSrid, String replicationUrl) {
        this.database = database;
        this.databaseSrid = databaseSrid;
        this.replicationUrl = replicationUrl;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        DataSource datasource = context.getDataSource(this.database);
        PostgresCoordinateMap coordinateMap = new PostgresCoordinateMap(datasource);
        PostgresReferenceMap referenceMap = new PostgresReferenceMap(datasource);
        PostgresHeaderRepository headerRepository = new PostgresHeaderRepository(datasource);
        PostgresNodeRepository nodeRepository = new PostgresNodeRepository(datasource);
        PostgresWayRepository wayRepository = new PostgresWayRepository(datasource);
        PostgresRelationRepository relationRepository = new PostgresRelationRepository(datasource);
        UpdateOsmDatabase.execute(coordinateMap, referenceMap, headerRepository, nodeRepository, wayRepository, relationRepository, this.databaseSrid, this.replicationUrl);
    }

    public static void execute(DataMap<Long, Coordinate> coordinateMap, DataMap<Long, List<Long>> referenceMap, HeaderRepository headerRepository, Repository<Long, Node> nodeRepository, Repository<Long, Way> wayRepository, Repository<Long, Relation> relationRepository, Integer databaseSrid, String replicationUrl) throws Exception {
        LocalDateTime replicationTimestamp;
        Optional<State> state;
        Header header = headerRepository.selectLatest();
        if (replicationUrl == null) {
            replicationUrl = header.getReplicationUrl();
        }
        StateReader stateReader = new StateReader(replicationUrl, true);
        Long sequenceNumber = header.getReplicationSequenceNumber();
        if (sequenceNumber <= 0L && (state = stateReader.getStateFromTimestamp(replicationTimestamp = header.getReplicationTimestamp())).isPresent()) {
            sequenceNumber = state.get().getSequenceNumber();
        }
        long nextSequenceNumber = sequenceNumber + 1L;
        URL changeUrl = stateReader.getUrl(replicationUrl, nextSequenceNumber, "osc.gz");
        logger.info("Updating the database with the changeset: {}", (Object)changeUrl);
        NodeGeometryBuilder buildNodeGeometry = new NodeGeometryBuilder();
        EntityProjectionTransformer reprojectNodeGeometry = new EntityProjectionTransformer(4326, databaseSrid);
        ChangeEntitiesHandler prepareNodeGeometry = new ChangeEntitiesHandler(buildNodeGeometry.andThen(reprojectNodeGeometry));
        ChangeElementsImporter<Node> importNodes = new ChangeElementsImporter<Node>(Node.class, nodeRepository);
        WayGeometryBuilder buildWayGeometry = new WayGeometryBuilder(coordinateMap);
        EntityProjectionTransformer reprojectWayGeometry = new EntityProjectionTransformer(4326, databaseSrid);
        ChangeEntitiesHandler prepareWayGeometry = new ChangeEntitiesHandler(buildWayGeometry.andThen(reprojectWayGeometry));
        ChangeElementsImporter<Way> importWays = new ChangeElementsImporter<Way>(Way.class, wayRepository);
        RelationMultiPolygonBuilder buildRelationGeometry = new RelationMultiPolygonBuilder(coordinateMap, referenceMap);
        EntityProjectionTransformer reprojectRelationGeometry = new EntityProjectionTransformer(4326, databaseSrid);
        ChangeEntitiesHandler prepareRelationGeometry = new ChangeEntitiesHandler(buildRelationGeometry.andThen(reprojectRelationGeometry));
        ChangeElementsImporter<Relation> importRelations = new ChangeElementsImporter<Relation>(Relation.class, relationRepository);
        Consumer<Change> entityProcessor = prepareNodeGeometry.andThen(importNodes).andThen(prepareWayGeometry).andThen(importWays).andThen(prepareRelationGeometry).andThen(importRelations);
        try (GZIPInputStream changeInputStream = new GZIPInputStream(new BufferedInputStream(changeUrl.openStream()));){
            new XmlChangeReader().stream(changeInputStream).forEach(entityProcessor);
        }
        URL stateUrl = stateReader.getUrl(replicationUrl, nextSequenceNumber, "state.txt");
        try (BufferedInputStream stateInputStream = new BufferedInputStream(stateUrl.openStream());){
            State state2 = new StateReader().readState(stateInputStream);
            headerRepository.put(new Header(state2.getSequenceNumber(), state2.getTimestamp(), header.getReplicationUrl(), header.getSource(), header.getWritingProgram()));
        }
    }

    public String toString() {
        return new StringJoiner(", ", UpdateOsmDatabase.class.getSimpleName() + "[", "]").add("database=" + this.database).add("databaseSrid=" + this.databaseSrid).add("replicationUrl='" + this.replicationUrl + "'").toString();
    }
}

