/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.collection;

import com.google.common.collect.Streams;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.baremaps.database.collection.AppendOnlyBuffer;
import org.apache.baremaps.database.collection.DataMap;

public class IndexedDataMap<E>
extends DataMap<Long, E> {
    private final Map<Long, Long> index;
    private final AppendOnlyBuffer<E> values;

    public IndexedDataMap(AppendOnlyBuffer<E> values) {
        this((Map<Long, Long>)new Long2LongOpenHashMap(), values);
    }

    public IndexedDataMap(Map<Long, Long> index, AppendOnlyBuffer<E> values) {
        this.index = index;
        this.values = values;
    }

    @Override
    public E put(Long key, E value) {
        Long oldIndex = this.index.get(key);
        long position = this.values.addPositioned(value);
        this.index.put(key, position);
        return oldIndex == null ? null : (E)this.values.read(oldIndex);
    }

    @Override
    public E get(Object key) {
        Long position = this.index.get(key);
        return position == null ? null : (E)this.values.read(position);
    }

    @Override
    protected Iterator<Long> keyIterator() {
        return this.index.keySet().iterator();
    }

    @Override
    protected Iterator<E> valueIterator() {
        return Streams.stream(this.keyIterator()).map(this::get).iterator();
    }

    @Override
    protected Iterator<Map.Entry<Long, E>> entryIterator() {
        return Streams.stream(this.keyIterator()).map(k -> Map.entry(k, this.get(k))).iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public long sizeAsLong() {
        Map<Long, Long> map = this.index;
        if (map instanceof DataMap) {
            DataMap dataMap = (DataMap)map;
            return dataMap.sizeAsLong();
        }
        return this.index.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.index.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.index.values().stream().map(this.values::read).anyMatch(value::equals);
    }

    @Override
    public E remove(Object key) {
        return this.values.read(this.index.remove(key));
    }

    @Override
    public void clear() {
        this.index.clear();
        this.values.clear();
    }
}

