/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi.recycler;

import aQute.bnd.annotation.spi.ServiceConsumer;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.spi.LoggingSystemProperty;
import org.apache.logging.log4j.spi.recycler.RecyclerFactory;
import org.apache.logging.log4j.spi.recycler.RecyclerFactoryProvider;
import org.apache.logging.log4j.util.PropertyEnvironment;
import org.apache.logging.log4j.util.ServiceLoaderUtil;

@ServiceConsumer(value=RecyclerFactoryProvider.class)
public final class RecyclerFactoryRegistry {
    private static final Map<String, RecyclerFactoryProvider> PROVIDER_BY_NAME = RecyclerFactoryRegistry.loadProviders();

    private static Map<String, RecyclerFactoryProvider> loadProviders() {
        return ServiceLoaderUtil.safeStream(RecyclerFactoryProvider.class, null).sorted(Comparator.comparing(RecyclerFactoryProvider::getOrder)).collect(Collectors.toMap(RecyclerFactoryProvider::getName, Function.identity(), (provider1, provider2) -> {
            String message = String.format("recycler factory providers `%s` (order=%d) and `%s` (order=%d) have conflicting names: `%s`", provider1.getClass().getCanonicalName(), provider1.getOrder(), provider2.getClass().getCanonicalName(), provider2.getOrder(), provider2.getName());
            throw new IllegalStateException(message);
        }, LinkedHashMap::new));
    }

    private RecyclerFactoryRegistry() {
    }

    public static Collection<RecyclerFactoryProvider> getRecyclerFactoryProviders() {
        return PROVIDER_BY_NAME.values();
    }

    public static RecyclerFactory findRecyclerFactory(PropertyEnvironment environment) {
        Objects.requireNonNull(environment, "environment");
        if (PROVIDER_BY_NAME.isEmpty()) {
            throw new IllegalStateException("couldn't find any recycler factories");
        }
        String name = environment.getStringProperty(LoggingSystemProperty.RECYCLER_FACTORY);
        if (name != null) {
            return RecyclerFactoryRegistry.findRecyclerFactoryByName(environment, name);
        }
        return PROVIDER_BY_NAME.values().stream().sorted(Comparator.comparing(RecyclerFactoryProvider::getOrder)).map(provider -> provider.createForEnvironment(environment)).filter(Objects::nonNull).findFirst().orElseThrow(() -> {
            String names = PROVIDER_BY_NAME.keySet().stream().map(name_ -> "`" + name_ + "`").collect(Collectors.joining(", "));
            String message = String.format("Couldn't find a recycler factory provider available for the provided environment. Names of the available recycler factory providers: %s", names);
            return new IllegalArgumentException(message);
        });
    }

    private static RecyclerFactory findRecyclerFactoryByName(PropertyEnvironment environment, String name) {
        RecyclerFactoryProvider provider = PROVIDER_BY_NAME.get(name);
        if (provider == null) {
            String names = PROVIDER_BY_NAME.keySet().stream().map(name_ -> "`" + name_ + "`").collect(Collectors.joining(", "));
            String message = String.format("Couldn't find a recycler factory provider of name `%s`. Names of the available recycler factory providers: %s", name, names);
            throw new IllegalArgumentException(message);
        }
        RecyclerFactory factory = provider.createForEnvironment(environment);
        if (factory == null) {
            String message = String.format("failed to configure recycler factory of name `%s` for the provided environment", name);
            throw new IllegalArgumentException(message);
        }
        return factory;
    }
}

