/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.columns;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageDao;
import mil.nga.geopackage.db.TableColumnKey;
import mil.nga.geopackage.features.columns.GeometryColumns;

public class GeometryColumnsDao
extends GeoPackageDao<GeometryColumns, TableColumnKey> {
    public static GeometryColumnsDao create(GeoPackageCore geoPackage) {
        return GeometryColumnsDao.create(geoPackage.getDatabase());
    }

    public static GeometryColumnsDao create(GeoPackageCoreConnection db) {
        return (GeometryColumnsDao)((Object)GeoPackageDao.createDao(db, GeometryColumns.class));
    }

    public GeometryColumnsDao(ConnectionSource connectionSource, Class<GeometryColumns> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public List<String> getFeatureTables() throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        List geometryColumns = this.queryForAll();
        for (GeometryColumns geometryColumn : geometryColumns) {
            tableNames.add(geometryColumn.getTableName());
        }
        return tableNames;
    }

    public GeometryColumns queryForId(TableColumnKey key) throws SQLException {
        GeometryColumns geometryColumns = null;
        if (key != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("table_name", key.getTableName());
            fieldValues.put("column_name", key.getColumnName());
            List results = this.queryForFieldValues(fieldValues);
            if (!results.isEmpty()) {
                if (results.size() > 1) {
                    throw new SQLException("More than one " + GeometryColumns.class.getSimpleName() + " returned for key. Table Name: " + key.getTableName() + ", Column Name: " + key.getColumnName());
                }
                geometryColumns = (GeometryColumns)results.get(0);
            }
        }
        return geometryColumns;
    }

    public TableColumnKey extractId(GeometryColumns data) throws SQLException {
        return data.getId();
    }

    public boolean idExists(TableColumnKey id) throws SQLException {
        return this.queryForId(id) != null;
    }

    public GeometryColumns queryForSameId(GeometryColumns data) throws SQLException {
        return this.queryForId(data.getId());
    }

    public int updateId(GeometryColumns data, TableColumnKey newId) throws SQLException {
        int count = 0;
        GeometryColumns readData = this.queryForId(data.getId());
        if (readData != null && newId != null) {
            readData.setId(newId);
            count = this.update(readData);
        }
        return count;
    }

    public int delete(GeometryColumns data) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        db.where().eq("table_name", (Object)data.getTableName()).and().eq("column_name", (Object)data.getColumnName());
        PreparedDelete deleteQuery = db.prepare();
        int deleted = this.delete(deleteQuery);
        return deleted;
    }

    public int deleteById(TableColumnKey id) throws SQLException {
        GeometryColumns geometryColumns;
        int count = 0;
        if (id != null && (geometryColumns = this.queryForId(id)) != null) {
            count = this.delete(geometryColumns);
        }
        return count;
    }

    public int deleteIds(Collection<TableColumnKey> idCollection) throws SQLException {
        int count = 0;
        if (idCollection != null) {
            for (TableColumnKey id : idCollection) {
                count += this.deleteById(id);
            }
        }
        return count;
    }

    public int update(GeometryColumns geometryColumns) throws SQLException {
        UpdateBuilder ub = this.updateBuilder();
        ub.updateColumnValue("geometry_type_name", (Object)geometryColumns.getGeometryTypeName());
        ub.updateColumnValue("srs_id", (Object)geometryColumns.getSrsId());
        ub.updateColumnValue("z", (Object)geometryColumns.getZ());
        ub.updateColumnValue("m", (Object)geometryColumns.getM());
        ub.where().eq("table_name", (Object)geometryColumns.getTableName()).and().eq("column_name", (Object)geometryColumns.getColumnName());
        PreparedUpdate update = ub.prepare();
        int updated = this.update(update);
        return updated;
    }

    public GeometryColumns queryForTableName(String tableName) throws SQLException {
        List results;
        GeometryColumns geometryColumns = null;
        if (tableName != null && !(results = this.queryForEq("table_name", tableName)).isEmpty()) {
            if (results.size() > 1) {
                throw new SQLException("More than one " + GeometryColumns.class.getSimpleName() + " returned for Table Name: " + tableName);
            }
            geometryColumns = (GeometryColumns)results.get(0);
        }
        return geometryColumns;
    }
}

