/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.user;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.contents.Contents;
import mil.nga.geopackage.db.GeoPackageConnection;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.srs.SpatialReferenceSystem;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.TileGrid;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrix.TileMatrixDao;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSetDao;
import mil.nga.geopackage.tiles.user.TileColumn;
import mil.nga.geopackage.tiles.user.TileConnection;
import mil.nga.geopackage.tiles.user.TileDaoUtils;
import mil.nga.geopackage.tiles.user.TileResultSet;
import mil.nga.geopackage.tiles.user.TileRow;
import mil.nga.geopackage.tiles.user.TileTable;
import mil.nga.geopackage.user.UserDao;
import mil.nga.proj.Projection;
import mil.nga.proj.ProjectionConstants;
import mil.nga.sf.proj.GeometryTransform;

public class TileDao
extends UserDao<TileColumn, TileTable, TileRow, TileResultSet> {
    private final TileConnection tileDb;
    private final TileMatrixSet tileMatrixSet;
    private final List<TileMatrix> tileMatrices;
    private final TreeMap<Long, TileMatrix> zoomLevelToTileMatrix = new TreeMap();
    private final long minZoom;
    private final long maxZoom;
    private final double[] widths;
    private final double[] heights;

    public TileDao(String database, GeoPackageConnection db, TileMatrixSet tileMatrixSet, List<TileMatrix> tileMatrices, TileTable table) {
        super(database, db, new TileConnection(db), table);
        this.tileDb = (TileConnection)this.getUserDb();
        this.tileMatrixSet = tileMatrixSet;
        this.tileMatrices = tileMatrices;
        this.widths = new double[tileMatrices.size()];
        this.heights = new double[tileMatrices.size()];
        this.projection = tileMatrixSet.getProjection();
        if (!tileMatrices.isEmpty()) {
            this.minZoom = tileMatrices.get(0).getZoomLevel();
            this.maxZoom = tileMatrices.get(tileMatrices.size() - 1).getZoomLevel();
        } else {
            this.minZoom = 0L;
            this.maxZoom = 0L;
        }
        for (int i = 0; i < tileMatrices.size(); ++i) {
            TileMatrix tileMatrix = tileMatrices.get(i);
            this.zoomLevelToTileMatrix.put(tileMatrix.getZoomLevel(), tileMatrix);
            this.widths[tileMatrices.size() - i - 1] = tileMatrix.getPixelXSize() * (double)tileMatrix.getTileWidth();
            this.heights[tileMatrices.size() - i - 1] = tileMatrix.getPixelYSize() * (double)tileMatrix.getTileHeight();
        }
        if (tileMatrixSet.getContents() == null) {
            throw new GeoPackageException(TileMatrixSet.class.getSimpleName() + " " + tileMatrixSet.getId() + " has null " + Contents.class.getSimpleName());
        }
        if (tileMatrixSet.getSrs() == null) {
            throw new GeoPackageException(TileMatrixSet.class.getSimpleName() + " " + tileMatrixSet.getId() + " has null " + SpatialReferenceSystem.class.getSimpleName());
        }
    }

    public BoundingBox getBoundingBox() {
        return this.tileMatrixSet.getBoundingBox();
    }

    public BoundingBox getBoundingBox(Projection projection) {
        return this.tileMatrixSet.getBoundingBox(projection);
    }

    public BoundingBox getBoundingBox(long zoomLevel) {
        TileGrid tileGrid;
        BoundingBox boundingBox = null;
        TileMatrix tileMatrix = this.getTileMatrix(zoomLevel);
        if (tileMatrix != null && (tileGrid = this.queryForTileGrid(zoomLevel)) != null) {
            BoundingBox matrixSetBoundingBox = this.getBoundingBox();
            boundingBox = TileBoundingBoxUtils.getBoundingBox((BoundingBox)matrixSetBoundingBox, (TileMatrix)tileMatrix, (TileGrid)tileGrid);
        }
        return boundingBox;
    }

    public BoundingBox getBoundingBox(long zoomLevel, Projection projection) {
        BoundingBox boundingBox = this.getBoundingBox(zoomLevel);
        if (boundingBox != null) {
            GeometryTransform transform = GeometryTransform.create((Projection)this.projection, (Projection)projection);
            boundingBox = boundingBox.transform(transform);
        }
        return boundingBox;
    }

    public TileGrid getTileGrid(long zoomLevel) {
        TileGrid tileGrid = null;
        TileMatrix tileMatrix = this.getTileMatrix(zoomLevel);
        if (tileMatrix != null) {
            tileGrid = new TileGrid(0L, 0L, tileMatrix.getMatrixWidth() - 1L, tileMatrix.getMatrixHeight() - 1L);
        }
        return tileGrid;
    }

    public void adjustTileMatrixLengths() {
        TileDaoUtils.adjustTileMatrixLengths((TileMatrixSet)this.tileMatrixSet, this.tileMatrices);
    }

    public TileRow newRow() {
        return new TileRow((TileTable)this.getTable());
    }

    public TileConnection getTileDb() {
        return this.tileDb;
    }

    public TileMatrixSet getTileMatrixSet() {
        return this.tileMatrixSet;
    }

    public List<TileMatrix> getTileMatrices() {
        return this.tileMatrices;
    }

    public Set<Long> getZoomLevels() {
        return Collections.unmodifiableSet(this.zoomLevelToTileMatrix.keySet());
    }

    public TileMatrix getTileMatrix(long zoomLevel) {
        return this.zoomLevelToTileMatrix.get(zoomLevel);
    }

    public TileMatrix getTileMatrixAtMinZoom() {
        return this.zoomLevelToTileMatrix.firstEntry().getValue();
    }

    public SpatialReferenceSystem getSrs() {
        return this.tileMatrixSet.getSrs();
    }

    public long getSrsId() {
        return this.tileMatrixSet.getSrsId();
    }

    public long getMinZoom() {
        return this.minZoom;
    }

    public long getMaxZoom() {
        return this.maxZoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileRow queryForTile(long column, long row, long zoomLevel) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("tile_column", column);
        fieldValues.put("tile_row", row);
        fieldValues.put("zoom_level", zoomLevel);
        TileRow tileRow = null;
        try (TileResultSet resultSet = (TileResultSet)this.queryForFieldValues(fieldValues);){
            if (resultSet.moveToNext()) {
                tileRow = (TileRow)resultSet.getRow();
            }
        }
        return tileRow;
    }

    public TileResultSet queryForTile(long zoomLevel) {
        return (TileResultSet)this.queryForEq("zoom_level", zoomLevel);
    }

    public TileResultSet queryForTileDescending(long zoomLevel) {
        return (TileResultSet)this.queryForEq("zoom_level", zoomLevel, null, null, "tile_row DESC, tile_column DESC");
    }

    public TileResultSet queryForTilesInColumn(long column, long zoomLevel) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("tile_column", column);
        fieldValues.put("zoom_level", zoomLevel);
        return (TileResultSet)this.queryForFieldValues(fieldValues);
    }

    public TileResultSet queryForTilesInRow(long row, long zoomLevel) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("tile_row", row);
        fieldValues.put("zoom_level", zoomLevel);
        return (TileResultSet)this.queryForFieldValues(fieldValues);
    }

    public Long getZoomLevel(double length) {
        Long zoomLevel = TileDaoUtils.getZoomLevel((double[])this.widths, (double[])this.heights, this.tileMatrices, (double)length);
        return zoomLevel;
    }

    public Long getZoomLevel(double width, double height) {
        Long zoomLevel = TileDaoUtils.getZoomLevel((double[])this.widths, (double[])this.heights, this.tileMatrices, (double)width, (double)height);
        return zoomLevel;
    }

    public Long getClosestZoomLevel(double length) {
        Long zoomLevel = TileDaoUtils.getClosestZoomLevel((double[])this.widths, (double[])this.heights, this.tileMatrices, (double)length);
        return zoomLevel;
    }

    public Long getClosestZoomLevel(double width, double height) {
        Long zoomLevel = TileDaoUtils.getClosestZoomLevel((double[])this.widths, (double[])this.heights, this.tileMatrices, (double)width, (double)height);
        return zoomLevel;
    }

    public Long getApproximateZoomLevel(double length) {
        Long zoomLevel = TileDaoUtils.getApproximateZoomLevel((double[])this.widths, (double[])this.heights, this.tileMatrices, (double)length);
        return zoomLevel;
    }

    public Long getApproximateZoomLevel(double width, double height) {
        Long zoomLevel = TileDaoUtils.getApproximateZoomLevel((double[])this.widths, (double[])this.heights, this.tileMatrices, (double)width, (double)height);
        return zoomLevel;
    }

    public double getMaxLength() {
        return TileDaoUtils.getMaxLength((double[])this.widths, (double[])this.heights);
    }

    public double getMinLength() {
        return TileDaoUtils.getMinLength((double[])this.widths, (double[])this.heights);
    }

    public TileResultSet queryByTileGrid(TileGrid tileGrid, long zoomLevel) {
        return this.queryByTileGrid(tileGrid, zoomLevel, null);
    }

    public TileResultSet queryByTileGrid(TileGrid tileGrid, long zoomLevel, String orderBy) {
        TileResultSet tileResultSet = null;
        if (tileGrid != null) {
            StringBuilder where = new StringBuilder();
            where.append(this.buildWhere("zoom_level", zoomLevel));
            where.append(" AND ");
            where.append(this.buildWhere("tile_column", tileGrid.getMinX(), ">="));
            where.append(" AND ");
            where.append(this.buildWhere("tile_column", tileGrid.getMaxX(), "<="));
            where.append(" AND ");
            where.append(this.buildWhere("tile_row", tileGrid.getMinY(), ">="));
            where.append(" AND ");
            where.append(this.buildWhere("tile_row", tileGrid.getMaxY(), "<="));
            String[] whereArgs = this.buildWhereArgs(new Object[]{zoomLevel, tileGrid.getMinX(), tileGrid.getMaxX(), tileGrid.getMinY(), tileGrid.getMaxY()});
            tileResultSet = (TileResultSet)this.query(where.toString(), whereArgs, null, null, orderBy);
        }
        return tileResultSet;
    }

    public TileGrid queryForTileGrid(long zoomLevel) {
        String where = this.buildWhere("zoom_level", zoomLevel);
        String[] whereArgs = this.buildWhereArgs(new Object[]{zoomLevel});
        Number minX = (Number)this.min("tile_column", where, whereArgs);
        Number maxX = (Number)this.max("tile_column", where, whereArgs);
        Number minY = (Number)this.min("tile_row", where, whereArgs);
        Number maxY = (Number)this.max("tile_row", where, whereArgs);
        TileGrid tileGrid = null;
        if (minX != null && maxX != null && minY != null && maxY != null) {
            tileGrid = new TileGrid(minX.longValue(), minY.longValue(), maxX.longValue(), maxY.longValue());
        }
        return tileGrid;
    }

    public int deleteTile(long column, long row, long zoomLevel) {
        StringBuilder where = new StringBuilder();
        where.append(this.buildWhere("zoom_level", zoomLevel));
        where.append(" AND ");
        where.append(this.buildWhere("tile_column", column));
        where.append(" AND ");
        where.append(this.buildWhere("tile_row", row));
        String[] whereArgs = this.buildWhereArgs(new Object[]{zoomLevel, column, row});
        int deleted = this.delete(where.toString(), whereArgs);
        return deleted;
    }

    public int count(long zoomLevel) {
        String where = this.buildWhere("zoom_level", zoomLevel);
        String[] whereArgs = this.buildWhereArgs(zoomLevel);
        return this.count(where, whereArgs);
    }

    public boolean isXYZTiles() {
        BoundingBox boundingBox = this.tileMatrixSet.getBoundingBox();
        BoundingBox wgs84BoundingBox = boundingBox.transform(GeometryTransform.create((Projection)this.projection, (long)4326L));
        boolean xyzTiles = false;
        if (wgs84BoundingBox.getMinLatitude() <= -85.05112877980659 && wgs84BoundingBox.getMaxLatitude() >= 85.0511287798066 && wgs84BoundingBox.getMinLongitude() <= -ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH && wgs84BoundingBox.getMaxLongitude() >= ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH) {
            xyzTiles = true;
            for (TileMatrix tileMatrix : this.tileMatrices) {
                long zoomLevel = tileMatrix.getZoomLevel();
                long tilesPerSide = TileBoundingBoxUtils.tilesPerSide((long)((int)zoomLevel));
                if (tileMatrix.getMatrixWidth() == tilesPerSide && tileMatrix.getMatrixHeight() == tilesPerSide) continue;
                xyzTiles = false;
                break;
            }
        }
        return xyzTiles;
    }

    public long[] getMapZoomRange() {
        return TileDaoUtils.getMapZoomRange((TileMatrixSet)this.tileMatrixSet, this.tileMatrices);
    }

    public long getMapMinZoom() {
        return TileDaoUtils.getMapMinZoom((TileMatrixSet)this.tileMatrixSet, this.tileMatrices);
    }

    public long getMapMaxZoom() {
        return TileDaoUtils.getMapMaxZoom((TileMatrixSet)this.tileMatrixSet, this.tileMatrices);
    }

    public long getMapZoom(TileMatrix tileMatrix) {
        return TileDaoUtils.getMapZoom((TileMatrixSet)this.tileMatrixSet, (TileMatrix)tileMatrix);
    }

    public long getMapZoom(long zoomLevel) {
        return this.getMapZoom(this.getTileMatrix(zoomLevel));
    }

    public TileMatrixSetDao getTileMatrixSetDao() {
        return TileMatrixSetDao.create((GeoPackageCoreConnection)this.getDb());
    }

    public TileMatrixDao getTileMatrixDao() {
        return TileMatrixDao.create((GeoPackageCoreConnection)this.getDb());
    }
}

