/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.FrozenIntSet;
import org.apache.lucene.util.automaton.StatePair;
import org.apache.lucene.util.automaton.StateSet;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.hppc.BitMixer;

public final class Operations {
    public static final int DEFAULT_DETERMINIZE_WORK_LIMIT = 10000;
    public static final int MAX_RECURSION_LEVEL = 1000;

    private Operations() {
    }

    public static Automaton concatenate(Automaton a1, Automaton a2) {
        return Operations.concatenate(Arrays.asList(a1, a2));
    }

    public static Automaton concatenate(List<Automaton> l) {
        Automaton result = new Automaton();
        for (Automaton a : l) {
            if (a.getNumStates() == 0) {
                result.finishState();
                return result;
            }
            int numStates = a.getNumStates();
            for (int s = 0; s < numStates; ++s) {
                result.createState();
            }
        }
        int stateOffset = 0;
        Transition t = new Transition();
        for (int i = 0; i < l.size(); ++i) {
            Automaton a = l.get(i);
            int numStates = a.getNumStates();
            Automaton nextA = i == l.size() - 1 ? null : l.get(i + 1);
            block3: for (int s = 0; s < numStates; ++s) {
                int numTransitions = a.initTransition(s, t);
                for (int j = 0; j < numTransitions; ++j) {
                    a.getNextTransition(t);
                    result.addTransition(stateOffset + s, stateOffset + t.dest, t.min, t.max);
                }
                if (!a.isAccept(s)) continue;
                Automaton followA = nextA;
                int followOffset = stateOffset;
                int upto = i + 1;
                while (followA != null) {
                    numTransitions = followA.initTransition(0, t);
                    for (int j = 0; j < numTransitions; ++j) {
                        followA.getNextTransition(t);
                        result.addTransition(stateOffset + s, followOffset + numStates + t.dest, t.min, t.max);
                    }
                    if (!followA.isAccept(0)) continue block3;
                    followOffset += followA.getNumStates();
                    followA = upto == l.size() - 1 ? null : l.get(upto + 1);
                    ++upto;
                }
                result.setAccept(stateOffset + s, true);
            }
            stateOffset += numStates;
        }
        if (result.getNumStates() == 0) {
            result.createState();
        }
        result.finishState();
        return result;
    }

    public static Automaton optional(Automaton a) {
        Automaton result = new Automaton();
        result.createState();
        result.setAccept(0, true);
        if (a.getNumStates() > 0) {
            result.copy(a);
            result.addEpsilon(0, 1);
        }
        result.finishState();
        return result;
    }

    public static Automaton repeat(Automaton a) {
        if (a.getNumStates() == 0) {
            return a;
        }
        Automaton.Builder builder = new Automaton.Builder();
        builder.createState();
        builder.setAccept(0, true);
        builder.copy(a);
        Transition t = new Transition();
        int count = a.initTransition(0, t);
        for (int i = 0; i < count; ++i) {
            a.getNextTransition(t);
            builder.addTransition(0, t.dest + 1, t.min, t.max);
        }
        int numStates = a.getNumStates();
        for (int s = 0; s < numStates; ++s) {
            if (!a.isAccept(s)) continue;
            count = a.initTransition(0, t);
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                builder.addTransition(s + 1, t.dest + 1, t.min, t.max);
            }
        }
        return builder.finish();
    }

    public static Automaton repeat(Automaton a, int count) {
        if (count == 0) {
            return Operations.repeat(a);
        }
        ArrayList<Automaton> as = new ArrayList<Automaton>();
        while (count-- > 0) {
            as.add(a);
        }
        as.add(Operations.repeat(a));
        return Operations.concatenate(as);
    }

    public static Automaton repeat(Automaton a, int min, int max) {
        Automaton b;
        if (min > max) {
            return Automata.makeEmpty();
        }
        if (min == 0) {
            b = Automata.makeEmptyString();
        } else if (min == 1) {
            b = new Automaton();
            b.copy(a);
        } else {
            ArrayList<Automaton> as = new ArrayList<Automaton>();
            for (int i = 0; i < min; ++i) {
                as.add(a);
            }
            b = Operations.concatenate(as);
        }
        Set<Integer> prevAcceptStates = Operations.toSet(b, 0);
        Automaton.Builder builder = new Automaton.Builder();
        builder.copy(b);
        for (int i = min; i < max; ++i) {
            int numStates = builder.getNumStates();
            builder.copy(a);
            for (int s : prevAcceptStates) {
                builder.addEpsilon(s, numStates);
            }
            prevAcceptStates = Operations.toSet(a, numStates);
        }
        return builder.finish();
    }

    private static Set<Integer> toSet(Automaton a, int offset) {
        int numStates = a.getNumStates();
        BitSet isAccept = a.getAcceptStates();
        HashSet<Integer> result = new HashSet<Integer>();
        for (int upto = 0; upto < numStates && (upto = isAccept.nextSetBit(upto)) != -1; ++upto) {
            result.add(offset + upto);
        }
        return result;
    }

    public static Automaton complement(Automaton a, int determinizeWorkLimit) {
        a = Operations.totalize(Operations.determinize(a, determinizeWorkLimit));
        int numStates = a.getNumStates();
        for (int p = 0; p < numStates; ++p) {
            a.setAccept(p, !a.isAccept(p));
        }
        return Operations.removeDeadStates(a);
    }

    public static Automaton minus(Automaton a1, Automaton a2, int determinizeWorkLimit) {
        if (Operations.isEmpty(a1) || a1 == a2) {
            return Automata.makeEmpty();
        }
        if (Operations.isEmpty(a2)) {
            return a1;
        }
        return Operations.intersection(a1, Operations.complement(a2, determinizeWorkLimit));
    }

    public static Automaton intersection(Automaton a1, Automaton a2) {
        if (a1 == a2) {
            return a1;
        }
        if (a1.getNumStates() == 0) {
            return a1;
        }
        if (a2.getNumStates() == 0) {
            return a2;
        }
        Transition[][] transitions1 = a1.getSortedTransitions();
        Transition[][] transitions2 = a2.getSortedTransitions();
        Automaton c = new Automaton();
        c.createState();
        ArrayDeque<StatePair> worklist = new ArrayDeque<StatePair>();
        HashMap<StatePair, StatePair> newstates = new HashMap<StatePair, StatePair>();
        StatePair p = new StatePair(0, 0, 0);
        worklist.add(p);
        newstates.put(p, p);
        while (worklist.size() > 0) {
            p = (StatePair)worklist.removeFirst();
            c.setAccept(p.s, a1.isAccept(p.s1) && a2.isAccept(p.s2));
            Transition[] t1 = transitions1[p.s1];
            Transition[] t2 = transitions2[p.s2];
            int b2 = 0;
            for (int n1 = 0; n1 < t1.length; ++n1) {
                while (b2 < t2.length && t2[b2].max < t1[n1].min) {
                    ++b2;
                }
                for (int n2 = b2; n2 < t2.length && t1[n1].max >= t2[n2].min; ++n2) {
                    if (t2[n2].max < t1[n1].min) continue;
                    StatePair q = new StatePair(t1[n1].dest, t2[n2].dest);
                    StatePair r = (StatePair)newstates.get(q);
                    if (r == null) {
                        q.s = c.createState();
                        worklist.add(q);
                        newstates.put(q, q);
                        r = q;
                    }
                    int min = t1[n1].min > t2[n2].min ? t1[n1].min : t2[n2].min;
                    int max = t1[n1].max < t2[n2].max ? t1[n1].max : t2[n2].max;
                    c.addTransition(p.s, r.s, min, max);
                }
            }
        }
        c.finishState();
        return Operations.removeDeadStates(c);
    }

    public static boolean sameLanguage(Automaton a1, Automaton a2) {
        if (a1 == a2) {
            return true;
        }
        return Operations.subsetOf(a2, a1) && Operations.subsetOf(a1, a2);
    }

    public static boolean hasDeadStates(Automaton a) {
        BitSet liveStates = Operations.getLiveStates(a);
        int numLive = liveStates.cardinality();
        int numStates = a.getNumStates();
        assert (numLive <= numStates) : "numLive=" + numLive + " numStates=" + numStates + " " + liveStates;
        return numLive < numStates;
    }

    public static boolean hasDeadStatesFromInitial(Automaton a) {
        BitSet reachableFromInitial = Operations.getLiveStatesFromInitial(a);
        BitSet reachableFromAccept = Operations.getLiveStatesToAccept(a);
        reachableFromInitial.andNot(reachableFromAccept);
        return !reachableFromInitial.isEmpty();
    }

    public static boolean hasDeadStatesToAccept(Automaton a) {
        BitSet reachableFromInitial = Operations.getLiveStatesFromInitial(a);
        BitSet reachableFromAccept = Operations.getLiveStatesToAccept(a);
        reachableFromAccept.andNot(reachableFromInitial);
        return !reachableFromAccept.isEmpty();
    }

    public static boolean subsetOf(Automaton a1, Automaton a2) {
        if (!a1.isDeterministic()) {
            throw new IllegalArgumentException("a1 must be deterministic");
        }
        if (!a2.isDeterministic()) {
            throw new IllegalArgumentException("a2 must be deterministic");
        }
        assert (!Operations.hasDeadStatesFromInitial(a1));
        assert (!Operations.hasDeadStatesFromInitial(a2));
        if (a1.getNumStates() == 0) {
            return true;
        }
        if (a2.getNumStates() == 0) {
            return Operations.isEmpty(a1);
        }
        Transition[][] transitions1 = a1.getSortedTransitions();
        Transition[][] transitions2 = a2.getSortedTransitions();
        ArrayDeque<StatePair> worklist = new ArrayDeque<StatePair>();
        HashSet<StatePair> visited = new HashSet<StatePair>();
        StatePair p = new StatePair(0, 0);
        worklist.add(p);
        visited.add(p);
        while (worklist.size() > 0) {
            p = (StatePair)worklist.removeFirst();
            if (a1.isAccept(p.s1) && !a2.isAccept(p.s2)) {
                return false;
            }
            Transition[] t1 = transitions1[p.s1];
            Transition[] t2 = transitions2[p.s2];
            int b2 = 0;
            for (int n1 = 0; n1 < t1.length; ++n1) {
                while (b2 < t2.length && t2[b2].max < t1[n1].min) {
                    ++b2;
                }
                int min1 = t1[n1].min;
                int max1 = t1[n1].max;
                for (int n2 = b2; n2 < t2.length && t1[n1].max >= t2[n2].min; ++n2) {
                    if (t2[n2].min > min1) {
                        return false;
                    }
                    if (t2[n2].max < 0x10FFFF) {
                        min1 = t2[n2].max + 1;
                    } else {
                        min1 = 0x10FFFF;
                        max1 = 0;
                    }
                    StatePair q = new StatePair(t1[n1].dest, t2[n2].dest);
                    if (visited.contains(q)) continue;
                    worklist.add(q);
                    visited.add(q);
                }
                if (min1 > max1) continue;
                return false;
            }
        }
        return true;
    }

    public static Automaton union(Automaton a1, Automaton a2) {
        return Operations.union(Arrays.asList(a1, a2));
    }

    public static Automaton union(Collection<Automaton> l) {
        Automaton result = new Automaton();
        result.createState();
        for (Automaton a : l) {
            result.copy(a);
        }
        int stateOffset = 1;
        for (Automaton a : l) {
            if (a.getNumStates() == 0) continue;
            result.addEpsilon(0, stateOffset);
            stateOffset += a.getNumStates();
        }
        result.finishState();
        return Operations.removeDeadStates(result);
    }

    public static Automaton determinize(Automaton a, int workLimit) {
        if (a.isDeterministic()) {
            return a;
        }
        if (a.getNumStates() <= 1) {
            return a;
        }
        Automaton.Builder b = new Automaton.Builder();
        FrozenIntSet initialset = new FrozenIntSet(new int[]{0}, BitMixer.mix(0) + 1, 0);
        b.createState();
        ArrayDeque<FrozenIntSet> worklist = new ArrayDeque<FrozenIntSet>();
        HashMap<FrozenIntSet, Integer> newstate = new HashMap<FrozenIntSet, Integer>();
        worklist.add(initialset);
        b.setAccept(0, a.isAccept(0));
        newstate.put(initialset, 0);
        PointTransitionSet points = new PointTransitionSet();
        StateSet statesSet = new StateSet(5);
        Transition t = new Transition();
        long effortSpent = 0L;
        long effortLimit = (long)workLimit * 10L;
        while (worklist.size() > 0) {
            FrozenIntSet s = (FrozenIntSet)worklist.removeFirst();
            if ((effortSpent += (long)s.values.length) >= effortLimit) {
                throw new TooComplexToDeterminizeException(a, workLimit);
            }
            for (int i = 0; i < s.values.length; ++i) {
                int s0 = s.values[i];
                int numTransitions = a.getNumTransitions(s0);
                a.initTransition(s0, t);
                for (int j = 0; j < numTransitions; ++j) {
                    a.getNextTransition(t);
                    points.add(t);
                }
            }
            if (points.count == 0) continue;
            points.sort();
            int lastPoint = -1;
            int accCount = 0;
            int r = s.state;
            for (int i = 0; i < points.count; ++i) {
                int dest;
                int j;
                int point = points.points[i].point;
                if (statesSet.size() > 0) {
                    assert (lastPoint != -1);
                    Integer q = (Integer)newstate.get(statesSet);
                    if (q == null) {
                        q = b.createState();
                        FrozenIntSet p = statesSet.freeze(q);
                        worklist.add(p);
                        b.setAccept(q, accCount > 0);
                        newstate.put(p, q);
                    } else assert (accCount > 0 == b.isAccept(q)) : "accCount=" + accCount + " vs existing accept=" + b.isAccept(q) + " states=" + statesSet;
                    b.addTransition(r, q, lastPoint, point - 1);
                }
                int[] transitions = points.points[i].ends.transitions;
                int limit = points.points[i].ends.next;
                for (j = 0; j < limit; j += 3) {
                    dest = transitions[j];
                    statesSet.decr(dest);
                    accCount -= a.isAccept(dest) ? 1 : 0;
                }
                points.points[i].ends.next = 0;
                transitions = points.points[i].starts.transitions;
                limit = points.points[i].starts.next;
                for (j = 0; j < limit; j += 3) {
                    dest = transitions[j];
                    statesSet.incr(dest);
                    accCount += a.isAccept(dest) ? 1 : 0;
                }
                lastPoint = point;
                points.points[i].starts.next = 0;
            }
            points.reset();
            assert (statesSet.size() == 0) : "size=" + statesSet.size();
        }
        Automaton result = b.finish();
        assert (result.isDeterministic());
        return result;
    }

    public static boolean isEmpty(Automaton a) {
        if (a.getNumStates() == 0) {
            return true;
        }
        if (!a.isAccept(0) && a.getNumTransitions(0) == 0) {
            return true;
        }
        if (a.isAccept(0)) {
            return false;
        }
        ArrayDeque<Integer> workList = new ArrayDeque<Integer>();
        BitSet seen = new BitSet(a.getNumStates());
        workList.add(0);
        seen.set(0);
        Transition t = new Transition();
        while (!workList.isEmpty()) {
            int state = (Integer)workList.removeFirst();
            if (a.isAccept(state)) {
                return false;
            }
            int count = a.initTransition(state, t);
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                if (seen.get(t.dest)) continue;
                workList.add(t.dest);
                seen.set(t.dest);
            }
        }
        return true;
    }

    public static boolean isTotal(Automaton a) {
        return Operations.isTotal(a, 0, 0x10FFFF);
    }

    public static boolean isTotal(Automaton a, int minAlphabet, int maxAlphabet) {
        if (a.isAccept(0) && a.getNumTransitions(0) == 1) {
            Transition t = new Transition();
            a.getTransition(0, 0, t);
            return t.dest == 0 && t.min == minAlphabet && t.max == maxAlphabet;
        }
        return false;
    }

    public static boolean run(Automaton a, String s) {
        assert (a.isDeterministic());
        int state = 0;
        int cp = 0;
        for (int i = 0; i < s.length(); i += Character.charCount(cp)) {
            cp = s.codePointAt(i);
            int nextState = a.step(state, cp);
            if (nextState == -1) {
                return false;
            }
            state = nextState;
        }
        return a.isAccept(state);
    }

    public static boolean run(Automaton a, IntsRef s) {
        assert (a.isDeterministic());
        int state = 0;
        for (int i = 0; i < s.length; ++i) {
            int nextState = a.step(state, s.ints[s.offset + i]);
            if (nextState == -1) {
                return false;
            }
            state = nextState;
        }
        return a.isAccept(state);
    }

    private static BitSet getLiveStates(Automaton a) {
        BitSet live = Operations.getLiveStatesFromInitial(a);
        live.and(Operations.getLiveStatesToAccept(a));
        return live;
    }

    private static BitSet getLiveStatesFromInitial(Automaton a) {
        int numStates = a.getNumStates();
        BitSet live = new BitSet(numStates);
        if (numStates == 0) {
            return live;
        }
        ArrayDeque<Integer> workList = new ArrayDeque<Integer>();
        live.set(0);
        workList.add(0);
        Transition t = new Transition();
        while (!workList.isEmpty()) {
            int s = (Integer)workList.removeFirst();
            int count = a.initTransition(s, t);
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                if (live.get(t.dest)) continue;
                live.set(t.dest);
                workList.add(t.dest);
            }
        }
        return live;
    }

    private static BitSet getLiveStatesToAccept(Automaton a) {
        int s;
        int s2;
        Automaton.Builder builder = new Automaton.Builder();
        Transition t = new Transition();
        int numStates = a.getNumStates();
        for (s2 = 0; s2 < numStates; ++s2) {
            builder.createState();
        }
        for (s2 = 0; s2 < numStates; ++s2) {
            int count = a.initTransition(s2, t);
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                builder.addTransition(t.dest, s2, t.min, t.max);
            }
        }
        Automaton a2 = builder.finish();
        ArrayDeque<Integer> workList = new ArrayDeque<Integer>();
        BitSet live = new BitSet(numStates);
        BitSet acceptBits = a.getAcceptStates();
        for (s = 0; s < numStates && (s = acceptBits.nextSetBit(s)) != -1; ++s) {
            live.set(s);
            workList.add(s);
        }
        while (!workList.isEmpty()) {
            s = (Integer)workList.removeFirst();
            int count = a2.initTransition(s, t);
            for (int i = 0; i < count; ++i) {
                a2.getNextTransition(t);
                if (live.get(t.dest)) continue;
                live.set(t.dest);
                workList.add(t.dest);
            }
        }
        return live;
    }

    public static Automaton removeDeadStates(Automaton a) {
        int numStates = a.getNumStates();
        BitSet liveSet = Operations.getLiveStates(a);
        int[] map = new int[numStates];
        Automaton result = new Automaton();
        for (int i = 0; i < numStates; ++i) {
            if (!liveSet.get(i)) continue;
            map[i] = result.createState();
            result.setAccept(map[i], a.isAccept(i));
        }
        Transition t = new Transition();
        for (int i = 0; i < numStates; ++i) {
            if (!liveSet.get(i)) continue;
            int numTransitions = a.initTransition(i, t);
            for (int j = 0; j < numTransitions; ++j) {
                a.getNextTransition(t);
                if (!liveSet.get(t.dest)) continue;
                result.addTransition(map[i], map[t.dest], t.min, t.max);
            }
        }
        result.finishState();
        assert (!Operations.hasDeadStates(result));
        return result;
    }

    public static boolean isFinite(Automaton a) {
        if (a.getNumStates() == 0) {
            return true;
        }
        return Operations.isFinite(new Transition(), a, 0, new BitSet(a.getNumStates()), new BitSet(a.getNumStates()), 0);
    }

    private static boolean isFinite(Transition scratch, Automaton a, int state, BitSet path, BitSet visited, int level) {
        if (level > 1000) {
            throw new IllegalArgumentException("input automaton is too large: " + level);
        }
        path.set(state);
        int numTransitions = a.initTransition(state, scratch);
        for (int t = 0; t < numTransitions; ++t) {
            a.getTransition(state, t, scratch);
            if (!path.get(scratch.dest) && (visited.get(scratch.dest) || Operations.isFinite(scratch, a, scratch.dest, path, visited, level + 1))) continue;
            return false;
        }
        path.clear(state);
        visited.set(state);
        return true;
    }

    public static String getCommonPrefix(Automaton a) {
        if (Operations.hasDeadStatesFromInitial(a)) {
            throw new IllegalArgumentException("input automaton has dead states");
        }
        if (Operations.isEmpty(a)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Transition scratch = new Transition();
        FixedBitSet visited = new FixedBitSet(a.getNumStates());
        FixedBitSet current = new FixedBitSet(a.getNumStates());
        FixedBitSet next = new FixedBitSet(a.getNumStates());
        current.set(0);
        block0: while (true) {
            int label = -1;
            int state = current.nextSetBit(0);
            while (state != Integer.MAX_VALUE) {
                visited.set(state);
                if (a.isAccept(state)) break block0;
                for (int transition = 0; transition < a.getNumTransitions(state); ++transition) {
                    a.getTransition(state, transition, scratch);
                    if (label == -1) {
                        label = scratch.min;
                    }
                    if (scratch.min != scratch.max || scratch.min != label) break block0;
                    next.set(scratch.dest);
                }
                state = state + 1 >= current.length() ? Integer.MAX_VALUE : current.nextSetBit(state + 1);
            }
            assert (label != -1) : "we should not get here since we checked no dead-end states up front!?";
            builder.appendCodePoint(label);
            FixedBitSet tmp = current;
            current = next;
            next = tmp;
            next.clear(0, next.length());
        }
        return builder.toString();
    }

    public static BytesRef getCommonPrefixBytesRef(Automaton a) {
        String prefix = Operations.getCommonPrefix(a);
        BytesRefBuilder builder = new BytesRefBuilder();
        for (int i = 0; i < prefix.length(); ++i) {
            char ch = prefix.charAt(i);
            if (ch > '\u00ff') {
                throw new IllegalStateException("automaton is not binary");
            }
            builder.append((byte)ch);
        }
        return builder.get();
    }

    public static IntsRef getSingleton(Automaton a) {
        block5: {
            if (!a.isDeterministic()) {
                throw new IllegalArgumentException("input automaton must be deterministic");
            }
            IntsRefBuilder builder = new IntsRefBuilder();
            HashSet<Integer> visited = new HashSet<Integer>();
            int s = 0;
            Transition t = new Transition();
            while (true) {
                visited.add(s);
                if (a.isAccept(s)) break;
                if (a.getNumTransitions(s) == 1) {
                    a.getTransition(s, 0, t);
                    if (t.min == t.max && !visited.contains(t.dest)) {
                        builder.append(t.min);
                        s = t.dest;
                        continue;
                    }
                }
                break block5;
                break;
            }
            if (a.getNumTransitions(s) == 0) {
                return builder.get();
            }
        }
        return null;
    }

    public static BytesRef getCommonSuffixBytesRef(Automaton a) {
        Automaton r = Operations.removeDeadStates(Operations.reverse(a));
        BytesRef ref = Operations.getCommonPrefixBytesRef(r);
        Operations.reverseBytes(ref);
        return ref;
    }

    private static void reverseBytes(BytesRef ref) {
        if (ref.length <= 1) {
            return;
        }
        int num = ref.length >> 1;
        for (int i = ref.offset; i < ref.offset + num; ++i) {
            byte b = ref.bytes[i];
            ref.bytes[i] = ref.bytes[ref.offset * 2 + ref.length - i - 1];
            ref.bytes[ref.offset * 2 + ref.length - i - 1] = b;
        }
    }

    public static Automaton reverse(Automaton a) {
        return Operations.reverse(a, null);
    }

    public static Automaton reverse(Automaton a, Set<Integer> initialStates) {
        if (Operations.isEmpty(a)) {
            return new Automaton();
        }
        int numStates = a.getNumStates();
        Automaton.Builder builder = new Automaton.Builder();
        builder.createState();
        for (int s = 0; s < numStates; ++s) {
            builder.createState();
        }
        builder.setAccept(1, true);
        Transition t = new Transition();
        for (int s = 0; s < numStates; ++s) {
            int numTransitions = a.getNumTransitions(s);
            a.initTransition(s, t);
            for (int i = 0; i < numTransitions; ++i) {
                a.getNextTransition(t);
                builder.addTransition(t.dest + 1, s + 1, t.min, t.max);
            }
        }
        Automaton result = builder.finish();
        BitSet acceptStates = a.getAcceptStates();
        for (int s = 0; s < numStates && (s = acceptStates.nextSetBit(s)) != -1; ++s) {
            result.addEpsilon(0, s + 1);
            if (initialStates == null) continue;
            initialStates.add(s + 1);
        }
        result.finishState();
        return result;
    }

    static Automaton totalize(Automaton a) {
        Automaton result = new Automaton();
        int numStates = a.getNumStates();
        for (int i = 0; i < numStates; ++i) {
            result.createState();
            result.setAccept(i, a.isAccept(i));
        }
        int deadState = result.createState();
        result.addTransition(deadState, deadState, 0, 0x10FFFF);
        Transition t = new Transition();
        for (int i = 0; i < numStates; ++i) {
            int maxi = 0;
            int count = a.initTransition(i, t);
            for (int j = 0; j < count; ++j) {
                a.getNextTransition(t);
                result.addTransition(i, t.dest, t.min, t.max);
                if (t.min > maxi) {
                    result.addTransition(i, deadState, maxi, t.min - 1);
                }
                if (t.max + 1 <= maxi) continue;
                maxi = t.max + 1;
            }
            if (maxi > 0x10FFFF) continue;
            result.addTransition(i, deadState, maxi, 0x10FFFF);
        }
        result.finishState();
        return result;
    }

    public static int[] topoSortStates(Automaton a) {
        int[] states;
        if (a.getNumStates() == 0) {
            return new int[0];
        }
        int numStates = a.getNumStates();
        BitSet visited = new BitSet(numStates);
        int upto = Operations.topoSortStatesRecurse(a, visited, states = new int[numStates], 0, 0, 0);
        if (upto < states.length) {
            int[] newStates = new int[upto];
            System.arraycopy(states, 0, newStates, 0, upto);
            states = newStates;
        }
        for (int i = 0; i < states.length / 2; ++i) {
            int s = states[i];
            states[i] = states[states.length - 1 - i];
            states[states.length - 1 - i] = s;
        }
        return states;
    }

    private static int topoSortStatesRecurse(Automaton a, BitSet visited, int[] states, int upto, int state, int level) {
        if (level > 1000) {
            throw new IllegalArgumentException("input automaton is too large: " + level);
        }
        Transition t = new Transition();
        int count = a.initTransition(state, t);
        for (int i = 0; i < count; ++i) {
            a.getNextTransition(t);
            if (visited.get(t.dest)) continue;
            visited.set(t.dest);
            upto = Operations.topoSortStatesRecurse(a, visited, states, upto, t.dest, level + 1);
        }
        states[upto] = state;
        return ++upto;
    }

    private static final class PointTransitionSet {
        int count;
        PointTransitions[] points = new PointTransitions[5];
        private static final int HASHMAP_CUTOVER = 30;
        private final HashMap<Integer, PointTransitions> map = new HashMap();
        private boolean useHash = false;

        private PointTransitionSet() {
        }

        private PointTransitions next(int point) {
            PointTransitions points0;
            if (this.count == this.points.length) {
                PointTransitions[] newArray = new PointTransitions[ArrayUtil.oversize(1 + this.count, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.points, 0, newArray, 0, this.count);
                this.points = newArray;
            }
            if ((points0 = this.points[this.count]) == null) {
                points0 = this.points[this.count] = new PointTransitions();
            }
            points0.reset(point);
            ++this.count;
            return points0;
        }

        private PointTransitions find(int point) {
            if (this.useHash) {
                Integer pi = point;
                PointTransitions p = this.map.get(pi);
                if (p == null) {
                    p = this.next(point);
                    this.map.put(pi, p);
                }
                return p;
            }
            for (int i = 0; i < this.count; ++i) {
                if (this.points[i].point != point) continue;
                return this.points[i];
            }
            PointTransitions p = this.next(point);
            if (this.count == 30) {
                assert (this.map.size() == 0);
                for (int i = 0; i < this.count; ++i) {
                    this.map.put(this.points[i].point, this.points[i]);
                }
                this.useHash = true;
            }
            return p;
        }

        public void reset() {
            if (this.useHash) {
                this.map.clear();
                this.useHash = false;
            }
            this.count = 0;
        }

        public void sort() {
            if (this.count > 1) {
                ArrayUtil.timSort((Comparable[])this.points, (int)0, (int)this.count);
            }
        }

        public void add(Transition t) {
            this.find((int)t.min).starts.add(t);
            this.find((int)(1 + t.max)).ends.add(t);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.count; ++i) {
                if (i > 0) {
                    s.append(' ');
                }
                s.append(this.points[i].point).append(':').append(this.points[i].starts.next / 3).append(',').append(this.points[i].ends.next / 3);
            }
            return s.toString();
        }
    }

    private static final class PointTransitions
    implements Comparable<PointTransitions> {
        int point;
        final TransitionList ends = new TransitionList();
        final TransitionList starts = new TransitionList();

        private PointTransitions() {
        }

        @Override
        public int compareTo(PointTransitions other) {
            return this.point - other.point;
        }

        public void reset(int point) {
            this.point = point;
            this.ends.next = 0;
            this.starts.next = 0;
        }

        public boolean equals(Object other) {
            return ((PointTransitions)other).point == this.point;
        }

        public int hashCode() {
            return this.point;
        }
    }

    private static final class TransitionList {
        int[] transitions = new int[3];
        int next;

        private TransitionList() {
        }

        public void add(Transition t) {
            if (this.transitions.length < this.next + 3) {
                this.transitions = ArrayUtil.grow(this.transitions, this.next + 3);
            }
            this.transitions[this.next] = t.dest;
            this.transitions[this.next + 1] = t.min;
            this.transitions[this.next + 2] = t.max;
            this.next += 3;
        }
    }
}

