/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.color;

import java.util.regex.Pattern;

public class ColorUtils {
    private static final Pattern hexColorPattern = Pattern.compile("^#?((\\p{XDigit}{3}){1,2}|(\\p{XDigit}{4}){1,2})$");
    private static final Pattern hexSingleColorPattern = Pattern.compile("^\\p{XDigit}{1,2}$");

    public static String toColor(String red, String green, String blue) {
        return ColorUtils.toColorWithAlpha(red, green, blue, null);
    }

    public static String toColorShorthand(String red, String green, String blue) {
        return ColorUtils.shorthandHex(ColorUtils.toColor(red, green, blue));
    }

    public static String toColorWithAlpha(String red, String green, String blue) {
        String defaultAlpha = "FF";
        if (red != null && !red.isEmpty() && Character.isLowerCase(red.charAt(0))) {
            defaultAlpha = defaultAlpha.toLowerCase();
        }
        return ColorUtils.toColorWithAlpha(red, green, blue, defaultAlpha);
    }

    public static String toColorShorthandWithAlpha(String red, String green, String blue) {
        return ColorUtils.shorthandHex(ColorUtils.toColorWithAlpha(red, green, blue));
    }

    public static String toColorWithAlpha(String red, String green, String blue, String alpha) {
        ColorUtils.validateHexSingle(red);
        ColorUtils.validateHexSingle(green);
        ColorUtils.validateHexSingle(blue);
        StringBuilder color = new StringBuilder("#");
        if (alpha != null) {
            color.append(ColorUtils.expandShorthandHexSingle(alpha));
        }
        color.append(ColorUtils.expandShorthandHexSingle(red));
        color.append(ColorUtils.expandShorthandHexSingle(green));
        color.append(ColorUtils.expandShorthandHexSingle(blue));
        return color.toString();
    }

    public static String toColorShorthandWithAlpha(String red, String green, String blue, String alpha) {
        return ColorUtils.shorthandHex(ColorUtils.toColorWithAlpha(red, green, blue, alpha));
    }

    public static int toColor(int red, int green, int blue) {
        return ColorUtils.toColorWithAlpha(red, green, blue, -1);
    }

    public static int toColorWithAlpha(int red, int green, int blue) {
        return ColorUtils.toColorWithAlpha(red, green, blue, 255);
    }

    public static int toColorWithAlpha(int red, int green, int blue, int alpha) {
        ColorUtils.validateRGB(red);
        ColorUtils.validateRGB(green);
        ColorUtils.validateRGB(blue);
        int color = (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        if (alpha != -1) {
            ColorUtils.validateRGB(alpha);
            color = (alpha & 0xFF) << 24 | color;
        }
        return color;
    }

    public static String toHex(int color) {
        ColorUtils.validateRGB(color);
        Object hex = Integer.toHexString(color).toUpperCase();
        if (((String)hex).length() == 1) {
            hex = "0" + (String)hex;
        }
        return hex;
    }

    public static String toHex(float color) {
        return ColorUtils.toHex(ColorUtils.toRGB(color));
    }

    public static int toRGB(String color) {
        ColorUtils.validateHexSingle((String)color);
        if (((String)color).length() == 1) {
            color = (String)color + (String)color;
        }
        return Integer.parseInt((String)color, 16);
    }

    public static int toRGB(float color) {
        ColorUtils.validateArithmeticRGB(color);
        return Math.round(255.0f * color);
    }

    public static float toArithmeticRGB(String color) {
        return ColorUtils.toArithmeticRGB(ColorUtils.toRGB(color));
    }

    public static float toArithmeticRGB(int color) {
        ColorUtils.validateRGB(color);
        return (float)color / 255.0f;
    }

    public static float[] toHSL(float red, float green, float blue) {
        ColorUtils.validateArithmeticRGB(red);
        ColorUtils.validateArithmeticRGB(green);
        ColorUtils.validateArithmeticRGB(blue);
        float min = Math.min(Math.min(red, green), blue);
        float max = Math.max(Math.max(red, green), blue);
        float range = max - min;
        float hue = 0.0f;
        if (range > 0.0f) {
            hue = red >= green && red >= blue ? (green - blue) / range : (green >= blue ? 2.0f + (blue - red) / range : 4.0f + (red - green) / range);
        }
        if ((hue *= 60.0f) < 0.0f) {
            hue += 360.0f;
        }
        float sum = min + max;
        float lightness = sum / 2.0f;
        float saturation = min == max ? 0.0f : (lightness < 0.5f ? range / sum : range / (2.0f - max - min));
        return new float[]{hue, saturation, lightness};
    }

    public static float[] toHSL(int red, int green, int blue) {
        return ColorUtils.toHSL(ColorUtils.toArithmeticRGB(red), ColorUtils.toArithmeticRGB(green), ColorUtils.toArithmeticRGB(blue));
    }

    public static float[] toArithmeticRGB(float hue, float saturation, float lightness) {
        ColorUtils.validateHue(hue);
        ColorUtils.validateSaturation(saturation);
        ColorUtils.validateLightness(lightness);
        float t2 = lightness <= 0.5f ? lightness * (saturation + 1.0f) : lightness + saturation - lightness * saturation;
        float t1 = lightness * 2.0f - t2;
        float red = ColorUtils.hslConvert(t1, t2, (hue /= 60.0f) + 2.0f);
        float green = ColorUtils.hslConvert(t1, t2, hue);
        float blue = ColorUtils.hslConvert(t1, t2, hue - 2.0f);
        return new float[]{red, green, blue};
    }

    public static int[] toRGB(float hue, float saturation, float lightness) {
        float[] arithmeticRGB = ColorUtils.toArithmeticRGB(hue, saturation, lightness);
        int[] rgb = new int[]{ColorUtils.toRGB(arithmeticRGB[0]), ColorUtils.toRGB(arithmeticRGB[1]), ColorUtils.toRGB(arithmeticRGB[2])};
        return rgb;
    }

    private static float hslConvert(float t1, float t2, float hue) {
        if (hue < 0.0f) {
            hue += 6.0f;
        }
        if (hue >= 6.0f) {
            hue -= 6.0f;
        }
        float value = hue < 1.0f ? (t2 - t1) * hue + t1 : (hue < 3.0f ? t2 : (hue < 4.0f ? (t2 - t1) * (4.0f - hue) + t1 : t1));
        return value;
    }

    public static String getRed(String hex) {
        return ColorUtils.getHexSingle(hex, 0);
    }

    public static String getGreen(String hex) {
        return ColorUtils.getHexSingle(hex, 1);
    }

    public static String getBlue(String hex) {
        return ColorUtils.getHexSingle(hex, 2);
    }

    public static String getAlpha(String hex) {
        return ColorUtils.getHexSingle(hex, -1);
    }

    private static String getHexSingle(String hex, int colorIndex) {
        ColorUtils.validateHex(hex);
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        int colorCharacters = 1;
        int numColors = hex.length();
        if (numColors > 4) {
            ++colorCharacters;
            numColors /= 2;
        }
        String color = null;
        if (colorIndex >= 0 || numColors > 3) {
            if (numColors > 3) {
                ++colorIndex;
            }
            int startIndex = colorIndex;
            if (colorCharacters > 1) {
                startIndex *= 2;
            }
            color = hex.substring(startIndex, startIndex + colorCharacters);
            color = ColorUtils.expandShorthandHexSingle(color);
        }
        return color;
    }

    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static String shorthandHex(String color) {
        ColorUtils.validateHex(color);
        if (color.length() > 5) {
            StringBuilder shorthandColor = new StringBuilder();
            int startIndex = 0;
            if (color.startsWith("#")) {
                shorthandColor.append("#");
                ++startIndex;
            }
            while (startIndex < color.length()) {
                String shorthand = ColorUtils.shorthandHexSingle(color.substring(startIndex, startIndex + 2));
                if (shorthand.length() > 1) {
                    shorthandColor = null;
                    break;
                }
                shorthandColor.append(shorthand);
                startIndex += 2;
            }
            if (shorthandColor != null) {
                color = shorthandColor.toString();
            }
        }
        return color;
    }

    public static String expandShorthandHex(String color) {
        ColorUtils.validateHex(color);
        if (color.length() < 6) {
            StringBuilder expandColor = new StringBuilder();
            int startIndex = 0;
            if (color.startsWith("#")) {
                expandColor.append("#");
                ++startIndex;
            }
            while (startIndex < color.length()) {
                String expand = ColorUtils.expandShorthandHexSingle(color.substring(startIndex, startIndex + 1));
                expandColor.append(expand);
                ++startIndex;
            }
            color = expandColor.toString();
        }
        return color;
    }

    public static String shorthandHexSingle(String color) {
        ColorUtils.validateHexSingle(color);
        if (color.length() > 1 && Character.toUpperCase(color.charAt(0)) == Character.toUpperCase(color.charAt(1))) {
            color = color.substring(0, 1);
        }
        return color;
    }

    public static String expandShorthandHexSingle(String color) {
        ColorUtils.validateHexSingle((String)color);
        if (((String)color).length() == 1) {
            color = (String)color + (String)color;
        }
        return color;
    }

    public static boolean isValidHex(String color) {
        return color != null && hexColorPattern.matcher(color).matches();
    }

    public static void validateHex(String color) {
        if (!ColorUtils.isValidHex(color)) {
            throw new IllegalArgumentException("Hex color must be in format #RRGGBB, #RGB, #AARRGGBB, #ARGB, RRGGBB, RGB, AARRGGBB, or ARGB, invalid value: " + color);
        }
    }

    public static boolean isValidHexSingle(String color) {
        return color != null && hexSingleColorPattern.matcher(color).matches();
    }

    public static void validateHexSingle(String color) {
        if (!ColorUtils.isValidHexSingle(color)) {
            throw new IllegalArgumentException("Must be in format FF or F, invalid value: " + color);
        }
    }

    public static boolean isValidRGB(int color) {
        return color >= 0 && color <= 255;
    }

    public static void validateRGB(int color) {
        if (!ColorUtils.isValidRGB(color)) {
            throw new IllegalArgumentException("Must be inclusively between 0 and 255, invalid value: " + color);
        }
    }

    public static boolean isValidArithmeticRGB(float color) {
        return (double)color >= 0.0 && (double)color <= 1.0;
    }

    public static void validateArithmeticRGB(float color) {
        if (!ColorUtils.isValidArithmeticRGB(color)) {
            throw new IllegalArgumentException("Must be inclusively between 0.0 and 1.0, invalid value: " + color);
        }
    }

    public static boolean isValidHue(float hue) {
        return (double)hue >= 0.0 && (double)hue <= 360.0;
    }

    public static void validateHue(float hue) {
        if (!ColorUtils.isValidHue(hue)) {
            throw new IllegalArgumentException("Must be inclusively between 0.0 and 360.0, invalid value: " + hue);
        }
    }

    public static boolean isValidSaturation(float saturation) {
        return (double)saturation >= 0.0 && (double)saturation <= 1.0;
    }

    public static void validateSaturation(float saturation) {
        if (!ColorUtils.isValidSaturation(saturation)) {
            throw new IllegalArgumentException("Must be inclusively between 0.0 and 1.0, invalid value: " + saturation);
        }
    }

    public static boolean isValidLightness(float lightness) {
        return (double)lightness >= 0.0 && (double)lightness <= 1.0;
    }

    public static void validateLightness(float lightness) {
        if (!ColorUtils.isValidLightness(lightness)) {
            throw new IllegalArgumentException("Must be inclusively between 0.0 and 1.0, invalid value: " + lightness);
        }
    }
}

