/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.ArrayList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicFunction;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.LibraryOperator;
import org.apache.calcite.sql.fun.SqlBasicAggFunction;
import org.apache.calcite.sql.fun.SqlCastOperator;
import org.apache.calcite.sql.fun.SqlExtractFunction;
import org.apache.calcite.sql.fun.SqlJsonDepthFunction;
import org.apache.calcite.sql.fun.SqlJsonKeysFunction;
import org.apache.calcite.sql.fun.SqlJsonLengthFunction;
import org.apache.calcite.sql.fun.SqlJsonModifyFunction;
import org.apache.calcite.sql.fun.SqlJsonPrettyFunction;
import org.apache.calcite.sql.fun.SqlJsonRemoveFunction;
import org.apache.calcite.sql.fun.SqlJsonStorageSizeFunction;
import org.apache.calcite.sql.fun.SqlJsonTypeFunction;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLikeOperator;
import org.apache.calcite.sql.fun.SqlMinMaxAggFunction;
import org.apache.calcite.sql.fun.SqlRegexpReplaceFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTimestampAddFunction;
import org.apache.calcite.sql.fun.SqlTimestampDiffFunction;
import org.apache.calcite.sql.fun.SqlTranslate3Function;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandHandlers;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Optionality;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SqlLibraryOperators {
    @LibraryOperator(libraries={SqlLibrary.CALCITE})
    public static final SqlFunction AGGREGATE = SqlBasicAggFunction.create("AGGREGATE", SqlKind.AGGREGATE_FN, ReturnTypes.ARG0, OperandTypes.MEASURE);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlFunction CONVERT_TIMEZONE = SqlBasicFunction.create("CONVERT_TIMEZONE", ReturnTypes.DATE_NULLABLE, OperandTypes.CHARACTER_CHARACTER_DATETIME, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATE_ADD = SqlBasicFunction.create(SqlKind.DATE_ADD, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.DATE_INTERVAL).withFunctionType(SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATE_DIFF = new SqlTimestampDiffFunction("DATE_DIFF", OperandTypes.family(SqlTypeFamily.DATE, SqlTypeFamily.DATE, SqlTypeFamily.ANY));
    @LibraryOperator(libraries={SqlLibrary.MSSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction DATEADD = new SqlTimestampAddFunction("DATEADD");
    @LibraryOperator(libraries={SqlLibrary.MSSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction DATEDIFF = new SqlTimestampDiffFunction("DATEDIFF", OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.DATE, SqlTypeFamily.DATE));
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlFunction DATE_PART = new SqlExtractFunction("DATE_PART"){

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            this.getSyntax().unparse(writer, this, call, leftPrec, rightPrec);
        }
    };
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATE_SUB = SqlBasicFunction.create(SqlKind.DATE_SUB, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.DATE_INTERVAL).withFunctionType(SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.MSSQL})
    public static final SqlFunction DATEPART = new SqlExtractFunction("DATEPART"){

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            this.getSyntax().unparse(writer, this, call, leftPrec, rightPrec);
        }
    };
    private static final SqlReturnTypeInference DECODE_RETURN_TYPE = opBinding -> {
        ArrayList<RelDataType> list = new ArrayList<RelDataType>();
        int n = opBinding.getOperandCount();
        for (int i = 1; i < n; ++i) {
            if (i < n - 1) {
                ++i;
            }
            list.add(opBinding.getOperandType(i));
        }
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType type = typeFactory.leastRestrictive(list);
        if (type != null && opBinding.getOperandCount() % 2 == 1) {
            type = typeFactory.createTypeWithNullability(type, true);
        }
        return type;
    };
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction DECODE = SqlBasicFunction.create(SqlKind.DECODE, DECODE_RETURN_TYPE, OperandTypes.VARIADIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.HIVE, SqlLibrary.SPARK})
    public static final SqlFunction IF = new SqlFunction("IF", SqlKind.IF, SqlLibraryOperators::inferIfReturnType, null, OperandTypes.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.ANY, SqlTypeFamily.ANY).and(OperandTypes.same(3, 1, 2)), SqlFunctionCategory.SYSTEM){

        @Override
        public boolean validRexOperands(int count, Litmus litmus) {
            return litmus.fail("not a rex operator", new Object[0]);
        }
    };
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlBasicFunction NVL = SqlBasicFunction.create(SqlKind.NVL, ReturnTypes.LEAST_RESTRICTIVE.andThen(SqlTypeTransforms.TO_NULLABLE_ALL), (SqlOperandTypeChecker)OperandTypes.SAME_SAME);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction IFNULL = NVL.withName("IFNULL");
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction LENGTH = SqlStdOperatorTable.CHAR_LENGTH.withName("LENGTH");
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE})
    public static final SqlFunction LPAD = SqlBasicFunction.create("LPAD", ReturnTypes.ARG0_NULLABLE_VARYING, OperandTypes.STRING_NUMERIC_OPTIONAL_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE})
    public static final SqlFunction RPAD = SqlBasicFunction.create("RPAD", ReturnTypes.ARG0_NULLABLE_VARYING, OperandTypes.STRING_NUMERIC_OPTIONAL_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE})
    public static final SqlFunction LTRIM = SqlBasicFunction.create(SqlKind.LTRIM, ReturnTypes.ARG0.andThen(SqlTypeTransforms.TO_NULLABLE).andThen(SqlTypeTransforms.TO_VARYING), (SqlOperandTypeChecker)OperandTypes.STRING).withFunctionType(SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE})
    public static final SqlFunction RTRIM = SqlBasicFunction.create(SqlKind.RTRIM, ReturnTypes.ARG0.andThen(SqlTypeTransforms.TO_NULLABLE).andThen(SqlTypeTransforms.TO_VARYING), (SqlOperandTypeChecker)OperandTypes.STRING).withFunctionType(SqlFunctionCategory.STRING);
    private static final SqlBasicFunction SUBSTR = SqlBasicFunction.create("SUBSTR", ReturnTypes.ARG0_NULLABLE_VARYING, OperandTypes.STRING_INTEGER_OPTIONAL_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction ENDS_WITH = SqlBasicFunction.create("ENDS_WITH", ReturnTypes.BOOLEAN_NULLABLE, OperandTypes.STRING_SAME_SAME, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction STARTS_WITH = SqlBasicFunction.create("STARTS_WITH", ReturnTypes.BOOLEAN_NULLABLE, OperandTypes.STRING_SAME_SAME, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction SUBSTR_BIG_QUERY = SUBSTR.withKind(SqlKind.SUBSTR_BIG_QUERY);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction SUBSTR_MYSQL = SUBSTR.withKind(SqlKind.SUBSTR_MYSQL);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction SUBSTR_ORACLE = SUBSTR.withKind(SqlKind.SUBSTR_ORACLE);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlFunction SUBSTR_POSTGRESQL = SUBSTR.withKind(SqlKind.SUBSTR_POSTGRESQL);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE})
    public static final SqlFunction GREATEST = SqlBasicFunction.create(SqlKind.GREATEST, ReturnTypes.LEAST_RESTRICTIVE.andThen(SqlTypeTransforms.TO_NULLABLE), OperandTypes.SAME_VARIADIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE})
    public static final SqlFunction LEAST = SqlBasicFunction.create(SqlKind.LEAST, ReturnTypes.LEAST_RESTRICTIVE.andThen(SqlTypeTransforms.TO_NULLABLE), OperandTypes.SAME_VARIADIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE, SqlLibrary.POSTGRESQL})
    public static final SqlFunction TRANSLATE3 = new SqlTranslate3Function();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_TYPE = new SqlJsonTypeFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_DEPTH = new SqlJsonDepthFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_LENGTH = new SqlJsonLengthFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_KEYS = new SqlJsonKeysFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_PRETTY = new SqlJsonPrettyFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_REMOVE = new SqlJsonRemoveFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_STORAGE_SIZE = new SqlJsonStorageSizeFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_INSERT = new SqlJsonModifyFunction("JSON_INSERT");
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_REPLACE = new SqlJsonModifyFunction("JSON_REPLACE");
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_SET = new SqlJsonModifyFunction("JSON_SET");
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.ORACLE})
    public static final SqlFunction REGEXP_REPLACE = new SqlRegexpReplaceFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction COMPRESS = SqlBasicFunction.create("COMPRESS", ReturnTypes.explicit(SqlTypeName.VARBINARY).andThen(SqlTypeTransforms.TO_NULLABLE), OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction EXTRACT_VALUE = SqlBasicFunction.create("EXTRACTVALUE", ReturnTypes.VARCHAR_2000.andThen(SqlTypeTransforms.FORCE_NULLABLE), (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction XML_TRANSFORM = SqlBasicFunction.create("XMLTRANSFORM", ReturnTypes.VARCHAR_2000.andThen(SqlTypeTransforms.FORCE_NULLABLE), (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction EXTRACT_XML = SqlBasicFunction.create("EXTRACT", ReturnTypes.VARCHAR_2000.andThen(SqlTypeTransforms.FORCE_NULLABLE), (SqlOperandTypeChecker)OperandTypes.STRING_STRING_OPTIONAL_STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction EXISTS_NODE = SqlBasicFunction.create("EXISTSNODE", ReturnTypes.INTEGER_NULLABLE.andThen(SqlTypeTransforms.FORCE_NULLABLE), (SqlOperandTypeChecker)OperandTypes.STRING_STRING_OPTIONAL_STRING);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlAggFunction BOOL_AND = new SqlMinMaxAggFunction("BOOL_AND", SqlKind.MIN, OperandTypes.BOOLEAN);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlAggFunction BOOL_OR = new SqlMinMaxAggFunction("BOOL_OR", SqlKind.MAX, OperandTypes.BOOLEAN);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction LOGICAL_AND = new SqlMinMaxAggFunction("LOGICAL_AND", SqlKind.MIN, OperandTypes.BOOLEAN);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction LOGICAL_OR = new SqlMinMaxAggFunction("LOGICAL_OR", SqlKind.MAX, OperandTypes.BOOLEAN);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction COUNTIF = SqlBasicAggFunction.create(SqlKind.COUNTIF, ReturnTypes.BIGINT, OperandTypes.BOOLEAN).withDistinct(Optionality.FORBIDDEN);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction ARRAY_AGG = SqlBasicAggFunction.create(SqlKind.ARRAY_AGG, ReturnTypes.andThen(ReturnTypes::stripOrderBy, ReturnTypes.TO_ARRAY), OperandTypes.ANY).withFunctionType(SqlFunctionCategory.SYSTEM).withSyntax(SqlSyntax.ORDERED_FUNCTION).withAllowsNullTreatment(true);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction ARRAY_CONCAT_AGG = SqlBasicAggFunction.create(SqlKind.ARRAY_CONCAT_AGG, ReturnTypes.ARG0, OperandTypes.ARRAY).withFunctionType(SqlFunctionCategory.SYSTEM).withSyntax(SqlSyntax.ORDERED_FUNCTION);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction STRING_AGG = SqlBasicAggFunction.create(SqlKind.STRING_AGG, ReturnTypes.ARG0_NULLABLE, OperandTypes.STRING.or(OperandTypes.STRING_STRING)).withFunctionType(SqlFunctionCategory.SYSTEM).withSyntax(SqlSyntax.ORDERED_FUNCTION);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlAggFunction GROUP_CONCAT = SqlBasicAggFunction.create(SqlKind.GROUP_CONCAT, ReturnTypes.andThen(ReturnTypes::stripOrderBy, ReturnTypes.ARG0_NULLABLE), OperandTypes.STRING.or(OperandTypes.STRING_STRING)).withFunctionType(SqlFunctionCategory.SYSTEM).withAllowsNullTreatment(false).withAllowsSeparator(true).withSyntax(SqlSyntax.ORDERED_FUNCTION);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlAggFunction MAX_BY = SqlStdOperatorTable.ARG_MAX.withName("MAX_BY");
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlAggFunction MIN_BY = SqlStdOperatorTable.ARG_MIN.withName("MIN_BY");
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATE = SqlBasicFunction.create("DATE", ReturnTypes.DATE_NULLABLE, OperandTypes.or(OperandTypes.STRING, OperandTypes.family(SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER), OperandTypes.TIMESTAMP_NTZ, OperandTypes.TIMESTAMP_LTZ, OperandTypes.sequence("DATE(TIMESTAMP WITH LOCAL TIME ZONE, VARCHAR)", OperandTypes.TIMESTAMP_LTZ, OperandTypes.CHARACTER)), SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATETIME = SqlBasicFunction.create("DATETIME", ReturnTypes.TIMESTAMP_NULLABLE, OperandTypes.or(OperandTypes.family(SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER), OperandTypes.DATE, OperandTypes.DATE_TIME, OperandTypes.TIMESTAMP_LTZ, OperandTypes.sequence("DATETIME(TIMESTAMP WITH LOCAL TIME ZONE, VARCHAR)", OperandTypes.TIMESTAMP_LTZ, OperandTypes.CHARACTER)), SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIME = SqlBasicFunction.create("TIME", ReturnTypes.TIME_NULLABLE, OperandTypes.or(OperandTypes.family(SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER), OperandTypes.TIMESTAMP_NTZ, OperandTypes.TIMESTAMP_LTZ, OperandTypes.sequence("TIME(TIMESTAMP WITH LOCAL TIME ZONE, VARCHAR)", OperandTypes.TIMESTAMP_LTZ, OperandTypes.CHARACTER)), SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIMESTAMP = SqlBasicFunction.create("TIMESTAMP", ReturnTypes.TIMESTAMP_LTZ.andThen(SqlTypeTransforms.TO_NULLABLE), OperandTypes.or(OperandTypes.CHARACTER, OperandTypes.CHARACTER_CHARACTER, OperandTypes.DATE, OperandTypes.DATE_CHARACTER, OperandTypes.TIMESTAMP_NTZ, OperandTypes.sequence("TIMESTAMP(TIMESTAMP, VARCHAR)", OperandTypes.TIMESTAMP_NTZ, OperandTypes.CHARACTER)), SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction CURRENT_DATETIME = SqlBasicFunction.create("CURRENT_DATETIME", ReturnTypes.TIMESTAMP.andThen(SqlTypeTransforms.TO_NULLABLE), OperandTypes.NILADIC.or(OperandTypes.STRING), SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATE_FROM_UNIX_DATE = SqlBasicFunction.create("DATE_FROM_UNIX_DATE", ReturnTypes.DATE_NULLABLE, OperandTypes.INTEGER, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction UNIX_DATE = SqlBasicFunction.create("UNIX_DATE", ReturnTypes.INTEGER_NULLABLE, OperandTypes.DATE, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction MONTHNAME = SqlBasicFunction.create("MONTHNAME", ReturnTypes.VARCHAR_2000, OperandTypes.DATETIME, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction DAYNAME = SqlBasicFunction.create("DAYNAME", ReturnTypes.VARCHAR_2000, OperandTypes.DATETIME, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction LEFT = SqlBasicFunction.create("LEFT", ReturnTypes.ARG0_NULLABLE_VARYING, OperandTypes.CBSTRING_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction REPEAT = SqlBasicFunction.create("REPEAT", ReturnTypes.ARG0_NULLABLE_VARYING, OperandTypes.STRING_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction RIGHT = SqlBasicFunction.create("RIGHT", ReturnTypes.ARG0_NULLABLE_VARYING, OperandTypes.CBSTRING_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction SPACE = SqlBasicFunction.create("SPACE", ReturnTypes.VARCHAR_2000_NULLABLE, OperandTypes.INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction STRCMP = SqlBasicFunction.create("STRCMP", ReturnTypes.INTEGER_NULLABLE, OperandTypes.STRING_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL, SqlLibrary.ORACLE})
    public static final SqlFunction SOUNDEX = SqlBasicFunction.create("SOUNDEX", ReturnTypes.VARCHAR_4_NULLABLE, OperandTypes.CHARACTER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlFunction DIFFERENCE = SqlBasicFunction.create("DIFFERENCE", ReturnTypes.INTEGER_NULLABLE, OperandTypes.STRING_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlSpecialOperator ILIKE = new SqlLikeOperator("ILIKE", SqlKind.LIKE, false, false);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlSpecialOperator NOT_ILIKE = new SqlLikeOperator("NOT ILIKE", SqlKind.LIKE, true, false);
    @LibraryOperator(libraries={SqlLibrary.SPARK, SqlLibrary.HIVE})
    public static final SqlSpecialOperator RLIKE = new SqlLikeOperator("RLIKE", SqlKind.RLIKE, false, true);
    @LibraryOperator(libraries={SqlLibrary.SPARK, SqlLibrary.HIVE})
    public static final SqlSpecialOperator NOT_RLIKE = new SqlLikeOperator("NOT RLIKE", SqlKind.RLIKE, true, true);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL, SqlLibrary.BIG_QUERY})
    public static final SqlFunction CONCAT_FUNCTION = SqlBasicFunction.create("CONCAT", ReturnTypes.MULTIVALENT_STRING_SUM_PRECISION_NULLABLE, OperandTypes.repeat(SqlOperandCountRanges.from(2), OperandTypes.STRING), SqlFunctionCategory.STRING).withOperandTypeInference(InferTypes.RETURN_TYPE);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction CONCAT2 = SqlBasicFunction.create("CONCAT", ReturnTypes.MULTIVALENT_STRING_SUM_PRECISION_NULLABLE, OperandTypes.STRING_SAME_SAME, SqlFunctionCategory.STRING).withOperandTypeInference(InferTypes.RETURN_TYPE).withKind(SqlKind.CONCAT2);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction ARRAY_LENGTH = SqlBasicFunction.create("ARRAY_LENGTH", ReturnTypes.INTEGER_NULLABLE, (SqlOperandTypeChecker)OperandTypes.ARRAY);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction ARRAY_REVERSE = SqlBasicFunction.create(SqlKind.ARRAY_REVERSE, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.ARRAY);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction ARRAY_CONCAT = SqlBasicFunction.create(SqlKind.ARRAY_CONCAT, ReturnTypes.LEAST_RESTRICTIVE, OperandTypes.AT_LEAST_ONE_SAME_VARIADIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL})
    public static final SqlFunction REVERSE = SqlBasicFunction.create(SqlKind.REVERSE, ReturnTypes.ARG0_NULLABLE_VARYING, (SqlOperandTypeChecker)OperandTypes.CHARACTER).withFunctionType(SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL})
    public static final SqlFunction FROM_BASE64 = SqlBasicFunction.create("FROM_BASE64", ReturnTypes.explicit(SqlTypeName.VARBINARY).andThen(SqlTypeTransforms.TO_NULLABLE), OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction TO_BASE64 = SqlBasicFunction.create("TO_BASE64", ReturnTypes.explicit(SqlTypeName.VARCHAR).andThen(SqlTypeTransforms.TO_NULLABLE), OperandTypes.STRING.or(OperandTypes.BINARY), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.ORACLE})
    public static final SqlFunction TO_DATE = SqlBasicFunction.create("TO_DATE", ReturnTypes.DATE_NULLABLE, OperandTypes.STRING_STRING, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.ORACLE})
    public static final SqlFunction TO_TIMESTAMP = SqlBasicFunction.create("TO_TIMESTAMP", ReturnTypes.DATE_NULLABLE, OperandTypes.STRING_STRING, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction FORMAT_TIME = SqlBasicFunction.create("FORMAT_TIME", ReturnTypes.VARCHAR_2000_NULLABLE, OperandTypes.CHARACTER_TIME, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction FORMAT_DATE = SqlBasicFunction.create("FORMAT_DATE", ReturnTypes.VARCHAR_2000_NULLABLE, OperandTypes.CHARACTER_DATE, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction FORMAT_TIMESTAMP = SqlBasicFunction.create("FORMAT_TIMESTAMP", ReturnTypes.VARCHAR_2000_NULLABLE, OperandTypes.sequence("FORMAT_TIMESTAMP(<CHARACTER>, <TIMESTAMP WITH LOCAL TIME ZONE>)", OperandTypes.CHARACTER, OperandTypes.TIMESTAMP_LTZ).or(OperandTypes.sequence("FORMAT_TIMESTAMP(<CHARACTER>, <TIMESTAMP WITH LOCAL TIME ZONE>, <CHARACTER>)", OperandTypes.CHARACTER, OperandTypes.TIMESTAMP_LTZ, OperandTypes.CHARACTER)), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction FORMAT_DATETIME = SqlBasicFunction.create("FORMAT_DATETIME", ReturnTypes.VARCHAR_2000_NULLABLE, OperandTypes.sequence("FORMAT_DATETIME(<CHARACTER>, <TIMESTAMP>)", OperandTypes.CHARACTER, OperandTypes.TIMESTAMP_NTZ).or(OperandTypes.sequence("FORMAT_DATETIME(<CHARACTER>, <TIMESTAMP>, <CHARACTER>)", OperandTypes.CHARACTER, OperandTypes.TIMESTAMP_NTZ, OperandTypes.CHARACTER)), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlBasicFunction TIMESTAMP_ADD2 = SqlBasicFunction.create(SqlKind.TIMESTAMP_ADD, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.TIMESTAMP_INTERVAL).withFunctionType(SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIMESTAMP_DIFF3 = new SqlTimestampDiffFunction("TIMESTAMP_DIFF", OperandTypes.family(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.TIMESTAMP, SqlTypeFamily.ANY));
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIME_ADD = SqlBasicFunction.create(SqlKind.TIME_ADD, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.TIME_INTERVAL).withFunctionType(SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIME_DIFF = new SqlTimestampDiffFunction("TIME_DIFF", OperandTypes.family(SqlTypeFamily.TIME, SqlTypeFamily.TIME, SqlTypeFamily.ANY));
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATE_TRUNC = SqlBasicFunction.create("DATE_TRUNC", ReturnTypes.DATE_NULLABLE, OperandTypes.sequence("'DATE_TRUNC(<DATE>, <DATETIME_INTERVAL>)'", OperandTypes.DATE, OperandTypes.dateInterval()), SqlFunctionCategory.TIMEDATE).withOperandHandler(OperandHandlers.OPERAND_1_MIGHT_BE_TIME_FRAME);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIME_SUB = SqlBasicFunction.create(SqlKind.TIME_SUB, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.TIME_INTERVAL).withFunctionType(SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIME_TRUNC = SqlBasicFunction.create("TIME_TRUNC", ReturnTypes.TIME_NULLABLE, OperandTypes.sequence("'TIME_TRUNC(<TIME>, <DATETIME_INTERVAL>)'", OperandTypes.TIME, OperandTypes.timeInterval()), SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlBasicFunction TIMESTAMP_SUB = SqlBasicFunction.create(SqlKind.TIMESTAMP_SUB, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.TIMESTAMP_INTERVAL).withFunctionType(SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATETIME_SUB = TIMESTAMP_SUB.withName("DATETIME_SUB");
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIMESTAMP_TRUNC = SqlBasicFunction.create("TIMESTAMP_TRUNC", ReturnTypes.TIMESTAMP_NULLABLE, OperandTypes.sequence("'TIMESTAMP_TRUNC(<TIMESTAMP>, <DATETIME_INTERVAL>)'", OperandTypes.TIMESTAMP, OperandTypes.timestampInterval()), SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIMESTAMP_SECONDS = SqlBasicFunction.create("TIMESTAMP_SECONDS", ReturnTypes.TIMESTAMP_NULLABLE, OperandTypes.INTEGER, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIMESTAMP_MILLIS = SqlBasicFunction.create("TIMESTAMP_MILLIS", ReturnTypes.TIMESTAMP_NULLABLE, OperandTypes.INTEGER, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIMESTAMP_MICROS = SqlBasicFunction.create("TIMESTAMP_MICROS", ReturnTypes.TIMESTAMP_NULLABLE, OperandTypes.INTEGER, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction UNIX_SECONDS = SqlBasicFunction.create("UNIX_SECONDS", ReturnTypes.BIGINT_NULLABLE, OperandTypes.TIMESTAMP, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction UNIX_MILLIS = SqlBasicFunction.create("UNIX_MILLIS", ReturnTypes.BIGINT_NULLABLE, OperandTypes.TIMESTAMP, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction UNIX_MICROS = SqlBasicFunction.create("UNIX_MICROS", ReturnTypes.BIGINT_NULLABLE, OperandTypes.TIMESTAMP, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATETIME_ADD = TIMESTAMP_ADD2.withName("DATETIME_ADD");
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATETIME_DIFF = new SqlTimestampDiffFunction("DATETIME_DIFF", OperandTypes.family(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.TIMESTAMP, SqlTypeFamily.ANY));
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.SPARK})
    public static final SqlFunction CHAR = SqlBasicFunction.create("CHAR", ReturnTypes.CHAR_FORCE_NULLABLE, OperandTypes.INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE, SqlLibrary.POSTGRESQL})
    public static final SqlFunction CHR = SqlBasicFunction.create("CHR", ReturnTypes.CHAR, OperandTypes.INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE})
    public static final SqlFunction TANH = SqlBasicFunction.create("TANH", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE})
    public static final SqlFunction COSH = SqlBasicFunction.create("COSH", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE})
    public static final SqlFunction SINH = SqlBasicFunction.create("SINH", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction MD5 = SqlBasicFunction.create("MD5", ReturnTypes.explicit(SqlTypeName.VARCHAR).andThen(SqlTypeTransforms.TO_NULLABLE), OperandTypes.STRING.or(OperandTypes.BINARY), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction SHA1 = SqlBasicFunction.create("SHA1", ReturnTypes.explicit(SqlTypeName.VARCHAR).andThen(SqlTypeTransforms.TO_NULLABLE), OperandTypes.STRING.or(OperandTypes.BINARY), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction POW = SqlStdOperatorTable.POWER.withName("POW");
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TRUNC = SqlStdOperatorTable.TRUNCATE.withName("TRUNC");
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlOperator INFIX_CAST = new SqlCastOperator();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlOperator NULL_SAFE_EQUAL = new SqlBinaryOperator("<=>", SqlKind.IS_NOT_DISTINCT_FROM, 30, true, ReturnTypes.BOOLEAN, InferTypes.FIRST_KNOWN, OperandTypes.COMPARABLE_UNORDERED_COMPARABLE_UNORDERED);

    private SqlLibraryOperators() {
    }

    private static @Nullable RelDataType inferIfReturnType(SqlOperatorBinding opBinding) {
        return opBinding.getTypeFactory().leastRestrictive(opBinding.collectOperandTypes().subList(1, 3));
    }
}

