/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.data.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.serializer.api.SerializationException;
import io.servicetalk.serializer.api.SerializerDeserializer;
import java.io.IOException;

final class JacksonSerializer<T>
implements SerializerDeserializer<T> {
    private final ObjectWriter writer;
    private final ObjectReader reader;

    JacksonSerializer(ObjectMapper mapper, Class<T> clazz) {
        this.writer = mapper.writerFor(clazz);
        this.reader = mapper.readerFor(clazz);
    }

    JacksonSerializer(ObjectMapper mapper, TypeReference<T> typeRef) {
        this.writer = mapper.writerFor(typeRef);
        this.reader = mapper.readerFor(typeRef);
    }

    JacksonSerializer(ObjectMapper mapper, JavaType type) {
        this.writer = mapper.writerFor(type);
        this.reader = mapper.readerFor(type);
    }

    public void serialize(T toSerialize, BufferAllocator allocator, Buffer buffer) {
        JacksonSerializer.doSerialize(this.writer, toSerialize, buffer);
    }

    public T deserialize(Buffer serializedData, BufferAllocator allocator) {
        try {
            return (T)this.reader.readValue(Buffer.asInputStream((Buffer)serializedData));
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    static <T> void doSerialize(ObjectWriter writer, T t, Buffer destination) {
        try {
            writer.writeValue(Buffer.asOutputStream((Buffer)destination), t);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }
}

