/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public class IteratorNextNode
extends JavaScriptBaseNode {
    @Node.Child
    private JSFunctionCallNode methodCallNode;
    @Node.Child
    private IsObjectNode isObjectNode;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected IteratorNextNode() {
        this.methodCallNode = JSFunctionCallNode.createCall();
        this.isObjectNode = IsObjectNode.create();
    }

    public static IteratorNextNode create() {
        return new IteratorNextNode();
    }

    public Object execute(IteratorRecord iteratorRecord, Object value) {
        Object nextMethod = iteratorRecord.getNextMethod();
        JSDynamicObject iterator = iteratorRecord.getIterator();
        Object result = this.methodCallNode.executeCall(JSArguments.createOneArg((Object)iterator, nextMethod, value));
        if (!this.isObjectNode.executeBoolean(result)) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorIteratorResultNotObject(result, this);
        }
        return result;
    }

    public Object execute(IteratorRecord iteratorRecord) {
        Object nextMethod = iteratorRecord.getNextMethod();
        JSDynamicObject iterator = iteratorRecord.getIterator();
        Object result = this.methodCallNode.executeCall(JSArguments.createZeroArg((Object)iterator, nextMethod));
        if (!this.isObjectNode.executeBoolean(result)) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorIteratorResultNotObject(result, this);
        }
        return result;
    }
}

