/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNodeGen;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

@ImportStatic(value={CompilerDirectives.class})
public abstract class IsJSObjectNode
extends JavaScriptBaseNode {
    protected static final int MAX_CLASS_COUNT = 1;
    private final boolean includeNullUndefined;

    protected IsJSObjectNode(boolean includeNullUndefined) {
        this.includeNullUndefined = includeNullUndefined;
    }

    public abstract boolean executeBoolean(Object var1);

    @Specialization(guards={"cachedClass != null", "isExact(object, cachedClass)"}, limit="MAX_CLASS_COUNT")
    protected static boolean isObjectCached(Object object, @Cached(value="getClassIfJSDynamicObject(object)") Class<?> cachedClass, @Cached(value="guardIsJSObject(object)") boolean cachedResult) {
        return cachedResult;
    }

    @Specialization(replaces={"isObjectCached"})
    protected boolean isObject(Object object, @Cached(value="createBinaryProfile()") ConditionProfile resultProfile) {
        return resultProfile.profile(this.guardIsJSObject(object));
    }

    public static IsJSObjectNode create() {
        return IsJSObjectNodeGen.create(false);
    }

    public static IsJSObjectNode createIncludeNullUndefined() {
        return IsJSObjectNodeGen.create(true);
    }

    protected boolean guardIsJSObject(Object obj) {
        if (this.includeNullUndefined) {
            return JSDynamicObject.isJSDynamicObject(obj);
        }
        return JSGuards.isJSObject(obj);
    }
}

