/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.xml;

import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.baremaps.openstreetmap.model.Change;
import org.apache.baremaps.openstreetmap.model.Element;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.model.Info;
import org.apache.baremaps.openstreetmap.model.Member;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.stream.StreamException;

public class XmlChangeSpliterator
implements Spliterator<Change> {
    private static final String ELEMENT_NAME_OSMCHANGE = "osmChange";
    private static final String ELEMENT_NAME_CREATE = "create";
    private static final String ELEMENT_NAME_DELETE = "delete";
    private static final String ELEMENT_NAME_MODIFY = "modify";
    private static final String ELEMENT_NAME_NODE = "node";
    private static final String ELEMENT_NAME_WAY = "way";
    private static final String ELEMENT_NAME_RELATION = "relation";
    private static final String ELEMENT_NAME_TAG = "tag";
    private static final String ELEMENT_NAME_NODE_REFERENCE = "nd";
    private static final String ELEMENT_NAME_MEMBER = "member";
    private static final String ATTRIBUTE_NAME_ID = "id";
    private static final String ATTRIBUTE_NAME_VERSION = "version";
    private static final String ATTRIBUTE_NAME_TIMESTAMP = "timestamp";
    private static final String ATTRIBUTE_NAME_USER_ID = "uid";
    private static final String ATTRIBUTE_NAME_CHANGESET_ID = "changeset";
    private static final String ATTRIBUTE_NAME_LATITUDE = "lat";
    private static final String ATTRIBUTE_NAME_LONGITUDE = "lon";
    private static final String ATTRIBUTE_NAME_KEY = "k";
    private static final String ATTRIBUTE_NAME_VALUE = "v";
    private static final String ATTRIBUTE_NAME_REF = "ref";
    private static final String ATTRIBUTE_NAME_TYPE = "type";
    private static final String ATTRIBUTE_NAME_ROLE = "role";
    public static final DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final XMLStreamReader reader;

    public XmlChangeSpliterator(InputStream input) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.isNamespaceAware", false);
        factory.setProperty("javax.xml.stream.isValidating", false);
        factory.setProperty("javax.xml.stream.isCoalescing", false);
        try {
            this.reader = factory.createXMLStreamReader(input);
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super Change> consumer) {
        try {
            if (this.reader.hasNext()) {
                int event = this.reader.next();
                switch (event) {
                    case 1: {
                        if (ELEMENT_NAME_OSMCHANGE.equals(this.reader.getLocalName())) {
                            return true;
                        }
                        Change entity = this.readChange();
                        consumer.accept(entity);
                        return true;
                    }
                    case 8: {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }

    private Change readChange() throws XMLStreamException {
        switch (this.reader.getLocalName()) {
            case "create": 
            case "delete": 
            case "modify": {
                Change.ChangeType type = Change.ChangeType.valueOf(this.reader.getLocalName().toUpperCase());
                ArrayList<Entity> elements = new ArrayList<Entity>();
                this.reader.nextTag();
                while (this.reader.getEventType() == 1) {
                    elements.add(this.readElement());
                    this.reader.nextTag();
                }
                return new Change(type, elements);
            }
        }
        throw new StreamException("Unexpected XML element: " + this.reader.getLocalName());
    }

    private Element readElement() throws XMLStreamException {
        switch (this.reader.getLocalName()) {
            case "node": {
                return this.readNode();
            }
            case "way": {
                return this.readWay();
            }
            case "relation": {
                return this.readRelation();
            }
        }
        throw new StreamException("Unexpected XML element: " + this.reader.getLocalName());
    }

    private Node readNode() throws XMLStreamException {
        long id = Long.parseLong(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_ID));
        Info info = this.readInfo();
        double latitude = Double.parseDouble(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_LATITUDE));
        double longitude = Double.parseDouble(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_LONGITUDE));
        HashMap<String, Object> tags = new HashMap<String, Object>();
        this.reader.nextTag();
        block6: while (this.reader.getEventType() == 1) {
            switch (this.reader.getLocalName()) {
                case "tag": {
                    this.readTag(tags);
                    continue block6;
                }
            }
            this.readUnknownElement();
        }
        return new Node(id, info, tags, latitude, longitude);
    }

    private Way readWay() throws XMLStreamException {
        long id = Long.parseLong(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_ID));
        Info info = this.readInfo();
        HashMap<String, Object> tags = new HashMap<String, Object>();
        ArrayList<Long> members = new ArrayList<Long>();
        this.reader.nextTag();
        block8: while (this.reader.getEventType() == 1) {
            switch (this.reader.getLocalName()) {
                case "tag": {
                    this.readTag(tags);
                    continue block8;
                }
                case "nd": {
                    this.readWayMember(members);
                    continue block8;
                }
            }
            this.readUnknownElement();
        }
        return new Way(id, info, tags, members);
    }

    private void readWayMember(List<Long> members) throws XMLStreamException {
        Long member = Long.parseLong(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_REF));
        members.add(member);
        this.reader.nextTag();
        this.reader.nextTag();
    }

    private Relation readRelation() throws XMLStreamException {
        long id = Long.parseLong(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_ID));
        Info info = this.readInfo();
        HashMap<String, Object> tags = new HashMap<String, Object>();
        ArrayList<Member> members = new ArrayList<Member>();
        this.reader.nextTag();
        block8: while (this.reader.getEventType() == 1) {
            switch (this.reader.getLocalName()) {
                case "tag": {
                    this.readTag(tags);
                    continue block8;
                }
                case "member": {
                    this.readRelationMember(members);
                    continue block8;
                }
            }
            this.readUnknownElement();
        }
        return new Relation(id, info, tags, members);
    }

    private void readRelationMember(List<Member> members) throws XMLStreamException {
        long id = Long.parseLong(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_REF));
        Member.MemberType type = Member.MemberType.valueOf(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_TYPE).toUpperCase());
        String role = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_ROLE);
        members.add(new Member(id, type, role));
        this.reader.nextTag();
        this.reader.nextTag();
    }

    private Info readInfo() {
        int version = Integer.parseInt(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_VERSION));
        LocalDateTime timestamp = LocalDateTime.parse(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_TIMESTAMP), format);
        String changesetValue = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_CHANGESET_ID);
        long changeset = changesetValue != null ? Long.parseLong(changesetValue) : -1L;
        String uidValue = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_USER_ID);
        int uid = uidValue != null ? Integer.parseInt(uidValue) : -1;
        return new Info(version, timestamp, changeset, uid);
    }

    private void readTag(Map<String, Object> tags) throws XMLStreamException {
        String name = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_KEY);
        String value = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_VALUE);
        tags.put(name, value);
        this.reader.nextTag();
        this.reader.nextTag();
    }

    private void readUnknownElement() throws XMLStreamException {
        int level = 0;
        do {
            if (this.reader.getEventType() == 1) {
                ++level;
            } else if (this.reader.getEventType() == 2) {
                --level;
            }
            this.reader.nextTag();
        } while (level > 0);
    }

    @Override
    public Spliterator<Change> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 1297;
    }
}

