/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.pbf;

import java.io.InputStream;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.baremaps.database.collection.DataMap;
import org.apache.baremaps.openstreetmap.function.BlobToBlockMapper;
import org.apache.baremaps.openstreetmap.function.BlockEntitiesHandler;
import org.apache.baremaps.openstreetmap.function.CoordinateMapBuilder;
import org.apache.baremaps.openstreetmap.function.EntityGeometryBuilder;
import org.apache.baremaps.openstreetmap.function.EntityProjectionTransformer;
import org.apache.baremaps.openstreetmap.function.ReferenceMapBuilder;
import org.apache.baremaps.openstreetmap.model.Block;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.pbf.BlobIterator;
import org.apache.baremaps.openstreetmap.pbf.PbfReader;
import org.apache.baremaps.stream.ConsumerUtils;
import org.apache.baremaps.stream.StreamUtils;
import org.locationtech.jts.geom.Coordinate;

public class PbfBlockReader
implements PbfReader<Block> {
    private int buffer = Runtime.getRuntime().availableProcessors();
    private boolean geometry = false;
    private int srid = 4326;
    private DataMap<Long, Coordinate> coordinateMap;
    private DataMap<Long, List<Long>> referenceMap;

    @Override
    public int buffer() {
        return this.buffer;
    }

    public PbfBlockReader buffer(int buffer) {
        this.buffer = buffer;
        return this;
    }

    @Override
    public boolean geometries() {
        return this.geometry;
    }

    public PbfBlockReader geometries(boolean geometries) {
        this.geometry = geometries;
        return this;
    }

    @Override
    public int projection() {
        return this.srid;
    }

    public PbfBlockReader projection(int srid) {
        this.srid = srid;
        return this;
    }

    @Override
    public DataMap<Long, Coordinate> coordinateMap() {
        return this.coordinateMap;
    }

    public PbfBlockReader coordinateMap(DataMap<Long, Coordinate> coordinateMap) {
        this.coordinateMap = coordinateMap;
        return this;
    }

    @Override
    public DataMap<Long, List<Long>> referenceMap() {
        return this.referenceMap;
    }

    public PbfBlockReader referenceMap(DataMap<Long, List<Long>> referenceMap) {
        this.referenceMap = referenceMap;
        return this;
    }

    @Override
    public Stream<Block> stream(InputStream inputStream) {
        Stream<Block> blocks = StreamUtils.bufferInSourceOrder(StreamUtils.stream(new BlobIterator(inputStream)), new BlobToBlockMapper(), Runtime.getRuntime().availableProcessors());
        if (this.geometry) {
            CoordinateMapBuilder coordinateMapBuilder = new CoordinateMapBuilder(this.coordinateMap);
            ReferenceMapBuilder referenceMapBuilder = new ReferenceMapBuilder(this.referenceMap);
            EntityGeometryBuilder entityGeometryBuilder = new EntityGeometryBuilder(this.coordinateMap, this.referenceMap);
            EntityProjectionTransformer entityProjectionTransformer = new EntityProjectionTransformer(4326, this.srid);
            Consumer<Entity> entityHandler = coordinateMapBuilder.andThen(referenceMapBuilder).andThen(entityGeometryBuilder).andThen(entityProjectionTransformer);
            Function<Block, Block> blockMapper = ConsumerUtils.consumeThenReturn(new BlockEntitiesHandler(entityHandler));
            blocks = blocks.map(blockMapper);
        }
        return blocks;
    }
}

