/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.model;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.baremaps.openstreetmap.model.Entity;

public final class Header
implements Entity {
    private final Long replicationSequenceNumber;
    private final LocalDateTime replicationTimestamp;
    private final String replicationUrl;
    private final String source;
    private final String writingProgram;

    public Header(Long replicationSequenceNumber, LocalDateTime replicationTimestamp, String replicationUrl, String source, String writingProgram) {
        this.replicationTimestamp = replicationTimestamp;
        this.replicationSequenceNumber = replicationSequenceNumber;
        this.replicationUrl = replicationUrl;
        this.source = source;
        this.writingProgram = writingProgram;
    }

    public LocalDateTime getReplicationTimestamp() {
        return this.replicationTimestamp;
    }

    public Long getReplicationSequenceNumber() {
        return this.replicationSequenceNumber;
    }

    public String getReplicationUrl() {
        return this.replicationUrl;
    }

    public String getSource() {
        return this.source;
    }

    public String getWritingProgram() {
        return this.writingProgram;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Header)) {
            return false;
        }
        Header header = (Header)o;
        return Objects.equals(this.replicationTimestamp, header.replicationTimestamp) && Objects.equals(this.replicationSequenceNumber, header.replicationSequenceNumber) && Objects.equals(this.replicationUrl, header.replicationUrl) && Objects.equals(this.source, header.source) && Objects.equals(this.writingProgram, header.writingProgram);
    }

    public int hashCode() {
        return Objects.hash(this.replicationTimestamp, this.replicationSequenceNumber, this.replicationUrl, this.source, this.writingProgram);
    }

    public String toString() {
        return new StringJoiner(", ", Header.class.getSimpleName() + "[", "]").add("replicationTimestamp=" + this.replicationTimestamp).add("replicationSequenceNumber=" + this.replicationSequenceNumber).add("replicationUrl='" + this.replicationUrl + "'").add("source='" + this.source + "'").add("writingProgram='" + this.writingProgram + "'").toString();
    }
}

