/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.type.geometry;

import java.nio.ByteBuffer;
import org.apache.baremaps.database.type.DataType;
import org.apache.baremaps.utils.GeometryUtils;
import org.locationtech.jts.geom.Geometry;

public class WKBDataType
implements DataType<Geometry> {
    @Override
    public int size(Geometry value) {
        byte[] bytes = GeometryUtils.serialize(value);
        return 4 + bytes.length;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, Geometry value) {
        byte[] bytes = GeometryUtils.serialize(value);
        buffer.putInt(position, 4 + bytes.length);
        buffer.put(position + 4, bytes);
    }

    @Override
    public Geometry read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        byte[] bytes = new byte[Math.max(size - 4, 0)];
        buffer.get(position + 4, bytes);
        return GeometryUtils.deserialize(bytes);
    }
}

