/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.type.geometry;

import java.nio.ByteBuffer;
import org.apache.baremaps.database.type.DataType;
import org.apache.baremaps.database.type.geometry.CoordinateArrayDataType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class LineStringDataType
implements DataType<LineString> {
    private final GeometryFactory geometryFactory;
    private final CoordinateArrayDataType coordinateArrayDataType;

    public LineStringDataType() {
        this(new GeometryFactory());
    }

    public LineStringDataType(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.coordinateArrayDataType = new CoordinateArrayDataType();
    }

    @Override
    public int size(LineString value) {
        return this.coordinateArrayDataType.size(value.getCoordinates());
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return this.coordinateArrayDataType.size(buffer, position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, LineString value) {
        this.coordinateArrayDataType.write(buffer, position, value.getCoordinates());
    }

    @Override
    public LineString read(ByteBuffer buffer, int position) {
        Coordinate[] coordinates = this.coordinateArrayDataType.read(buffer, position);
        return this.geometryFactory.createLineString(coordinates);
    }
}

