/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.type;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.baremaps.database.type.DataType;

public class StringDataType
implements DataType<String> {
    @Override
    public int size(String value) {
        return 4 + value.getBytes(StandardCharsets.UTF_8).length;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        buffer.putInt(position, this.size(value));
        buffer.put(position + 4, bytes, 0, bytes.length);
    }

    @Override
    public String read(ByteBuffer buffer, int position) {
        int size = this.size(buffer, position);
        byte[] bytes = new byte[Math.max(size - 4, 0)];
        buffer.get(position + 4, bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

