/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="link")
public class Link {
    @Valid
    private String href;
    @Valid
    private String rel;
    @Valid
    private String type;
    @Valid
    private Boolean templated;
    @Valid
    private String varBase;
    @Valid
    private String hreflang;
    @Valid
    private String title;
    @Valid
    private Integer length;

    public Link href(String href) {
        this.href = href;
        return this;
    }

    @ApiModelProperty(required=true, value="Supplies the URI to a remote resource (or resource fragment).")
    @JsonProperty(value="href")
    @NotNull
    public String getHref() {
        return this.href;
    }

    @JsonProperty(value="href")
    public void setHref(String href) {
        this.href = href;
    }

    public Link rel(String rel) {
        this.rel = rel;
        return this;
    }

    @ApiModelProperty(required=true, value="The type or semantics of the relation.")
    @JsonProperty(value="rel")
    @NotNull
    public String getRel() {
        return this.rel;
    }

    @JsonProperty(value="rel")
    public void setRel(String rel) {
        this.rel = rel;
    }

    public Link type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="A hint indicating what the media type of the result of dereferencing the link should be.")
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    public Link templated(Boolean templated) {
        this.templated = templated;
        return this;
    }

    @ApiModelProperty(value="This flag set to true if the link is a URL template.")
    @JsonProperty(value="templated")
    public Boolean getTemplated() {
        return this.templated;
    }

    @JsonProperty(value="templated")
    public void setTemplated(Boolean templated) {
        this.templated = templated;
    }

    public Link varBase(String varBase) {
        this.varBase = varBase;
        return this;
    }

    @ApiModelProperty(value="A base path to retrieve semantic information about the variables used in URL template.")
    @JsonProperty(value="varBase")
    public String getVarBase() {
        return this.varBase;
    }

    @JsonProperty(value="varBase")
    public void setVarBase(String varBase) {
        this.varBase = varBase;
    }

    public Link hreflang(String hreflang) {
        this.hreflang = hreflang;
        return this;
    }

    @ApiModelProperty(value="A hint indicating what the language of the result of dereferencing the link should be.")
    @JsonProperty(value="hreflang")
    public String getHreflang() {
        return this.hreflang;
    }

    @JsonProperty(value="hreflang")
    public void setHreflang(String hreflang) {
        this.hreflang = hreflang;
    }

    public Link title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Used to label the destination of a link such that it can be used as a human-readable identifier.")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public Link length(Integer length) {
        this.length = length;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="length")
    public Integer getLength() {
        return this.length;
    }

    @JsonProperty(value="length")
    public void setLength(Integer length) {
        this.length = length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equals(this.href, link.href) && Objects.equals(this.rel, link.rel) && Objects.equals(this.type, link.type) && Objects.equals(this.templated, link.templated) && Objects.equals(this.varBase, link.varBase) && Objects.equals(this.hreflang, link.hreflang) && Objects.equals(this.title, link.title) && Objects.equals(this.length, link.length);
    }

    public int hashCode() {
        return Objects.hash(this.href, this.rel, this.type, this.templated, this.varBase, this.hreflang, this.title, this.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Link {\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    rel: ").append(this.toIndentedString(this.rel)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    templated: ").append(this.toIndentedString(this.templated)).append("\n");
        sb.append("    varBase: ").append(this.toIndentedString(this.varBase)).append("\n");
        sb.append("    hreflang: ").append(this.toIndentedString(this.hreflang)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

