/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.baremaps.ogcapi.model.GeoJSONFeature;

@JsonTypeName(value="FeatureCollection")
public class FeatureCollection {
    @Valid
    private TypeEnum type;
    @Valid
    private List<GeoJSONFeature> features = new ArrayList<GeoJSONFeature>();
    @Valid
    private List<BigDecimal> bbox = null;

    public FeatureCollection type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @NotNull
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public FeatureCollection features(List<GeoJSONFeature> features) {
        this.features = features;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="features")
    @NotNull
    public List<GeoJSONFeature> getFeatures() {
        return this.features;
    }

    @JsonProperty(value="features")
    public void setFeatures(List<GeoJSONFeature> features) {
        this.features = features;
    }

    public FeatureCollection addFeaturesItem(GeoJSONFeature featuresItem) {
        if (this.features == null) {
            this.features = new ArrayList<GeoJSONFeature>();
        }
        this.features.add(featuresItem);
        return this;
    }

    public FeatureCollection removeFeaturesItem(GeoJSONFeature featuresItem) {
        if (featuresItem != null && this.features != null) {
            this.features.remove(featuresItem);
        }
        return this;
    }

    public FeatureCollection bbox(List<BigDecimal> bbox) {
        this.bbox = bbox;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="bbox")
    @Size(min=4)
    public @Size(min=4) List<BigDecimal> getBbox() {
        return this.bbox;
    }

    @JsonProperty(value="bbox")
    public void setBbox(List<BigDecimal> bbox) {
        this.bbox = bbox;
    }

    public FeatureCollection addBboxItem(BigDecimal bboxItem) {
        if (this.bbox == null) {
            this.bbox = new ArrayList<BigDecimal>();
        }
        this.bbox.add(bboxItem);
        return this;
    }

    public FeatureCollection removeBboxItem(BigDecimal bboxItem) {
        if (bboxItem != null && this.bbox != null) {
            this.bbox.remove(bboxItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureCollection featureCollection = (FeatureCollection)o;
        return Objects.equals((Object)this.type, (Object)featureCollection.type) && Objects.equals(this.features, featureCollection.features) && Objects.equals(this.bbox, featureCollection.bbox);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.features, this.bbox});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureCollection {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    bbox: ").append(this.toIndentedString(this.bbox)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        FEATURECOLLECTION(String.valueOf("FeatureCollection"));

        private String value;

        private TypeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromString(String s) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected string value '" + s + "'");
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

