/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.baremaps.config.ConfigReader;
import org.apache.baremaps.ogcapi.api.StylesApi;
import org.apache.baremaps.ogcapi.model.StyleSet;
import org.apache.baremaps.ogcapi.model.StyleSetEntry;
import org.apache.baremaps.vectortile.style.Style;
import org.apache.baremaps.vectortile.style.StyleSource;

@Singleton
public class StylesResource
implements StylesApi {
    private final Style style;

    @Inject
    public StylesResource(@Context UriInfo uriInfo, @Named(value="style") Path style, ObjectMapper objectMapper) throws IOException {
        this.style = (Style)objectMapper.readValue(new ConfigReader().read(style), Style.class);
        StyleSource source = new StyleSource();
        source.setType("vector");
        source.setUrl(uriInfo.getBaseUri().toString() + "tiles/default");
        this.style.setSources(Map.of("baremaps", source));
    }

    @Override
    public Response getStyleSet() {
        StyleSetEntry styleSetEntry = new StyleSetEntry();
        styleSetEntry.setId("default");
        StyleSet styleSet = new StyleSet();
        styleSet.setStyles(List.of(styleSetEntry));
        return Response.ok((Object)styleSet).build();
    }

    @Override
    public Response getStyle(String styleId) {
        return Response.ok((Object)this.style).build();
    }

    @Override
    public Response getStyleMetadata(String styleId) {
        throw new UnsupportedOperationException();
    }
}

