/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.api;

import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.transport.api.ConnectionAcceptor;
import io.servicetalk.transport.api.ConnectionContext;
import java.util.Objects;

final class ConnectionAcceptorAppender
implements ConnectionAcceptor {
    private final ConnectionAcceptor first;
    private final ConnectionAcceptor second;
    private final CompositeCloseable closeable;

    ConnectionAcceptorAppender(ConnectionAcceptor first, ConnectionAcceptor second) {
        this.first = Objects.requireNonNull(first);
        this.second = Objects.requireNonNull(second);
        this.closeable = AsyncCloseables.newCompositeCloseable().appendAll(new AsyncCloseable[]{first, second});
    }

    @Override
    public Completable accept(ConnectionContext context) {
        return this.first.accept(context).concat(Completable.defer(() -> this.second.accept(context)));
    }

    @Override
    public Completable closeAsync() {
        return this.closeable.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.closeable.closeAsyncGracefully();
    }
}

