/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.api;

import io.servicetalk.transport.api.DefaultConnectExecutionStrategy;
import io.servicetalk.transport.api.ExecutionStrategy;

public interface ConnectExecutionStrategy
extends ExecutionStrategy {
    @Override
    default public boolean hasOffloads() {
        return ExecutionStrategy.super.hasOffloads() || this.isConnectOffloaded();
    }

    public boolean isConnectOffloaded();

    @Override
    default public ConnectExecutionStrategy merge(ExecutionStrategy other) {
        ConnectExecutionStrategy asCES = ConnectExecutionStrategy.from(other);
        return this.hasOffloads() ? (asCES.hasOffloads() ? ConnectExecutionStrategy.offloadAll() : this) : (asCES.hasOffloads() ? asCES : ConnectExecutionStrategy.offloadNone());
    }

    public static ConnectExecutionStrategy offloadNone() {
        return DefaultConnectExecutionStrategy.CONNECT_NO_OFFLOADS;
    }

    public static ConnectExecutionStrategy offloadAll() {
        return DefaultConnectExecutionStrategy.CONNECT_OFFLOADED;
    }

    public static ConnectExecutionStrategy from(ExecutionStrategy executionStrategy) {
        return executionStrategy instanceof ConnectExecutionStrategy ? (ConnectExecutionStrategy)executionStrategy : (executionStrategy.hasOffloads() ? ConnectExecutionStrategy.offloadAll() : ConnectExecutionStrategy.offloadNone());
    }
}

