/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import java.util.Objects;
import javax.annotation.Nullable;

public final class Http2ErrorCode {
    public static final Http2ErrorCode NO_ERROR = new Http2ErrorCode(0, "NO_ERROR");
    public static final Http2ErrorCode PROTOCOL_ERROR = new Http2ErrorCode(1, "PROTOCOL_ERROR");
    public static final Http2ErrorCode INTERNAL_ERROR = new Http2ErrorCode(2, "INTERNAL_ERROR");
    public static final Http2ErrorCode FLOW_CONTROL_ERROR = new Http2ErrorCode(3, "FLOW_CONTROL_ERROR");
    public static final Http2ErrorCode SETTINGS_TIMEOUT = new Http2ErrorCode(4, "SETTINGS_TIMEOUT");
    public static final Http2ErrorCode STREAM_CLOSED = new Http2ErrorCode(5, "STREAM_CLOSED");
    public static final Http2ErrorCode FRAME_SIZE_ERROR = new Http2ErrorCode(6, "FRAME_SIZE_ERROR");
    public static final Http2ErrorCode REFUSED_STREAM = new Http2ErrorCode(7, "REFUSED_STREAM");
    public static final Http2ErrorCode CANCEL = new Http2ErrorCode(8, "CANCEL");
    public static final Http2ErrorCode COMPRESSION_ERROR = new Http2ErrorCode(9, "COMPRESSION_ERROR");
    public static final Http2ErrorCode CONNECT_ERROR = new Http2ErrorCode(10, "CONNECT_ERROR");
    public static final Http2ErrorCode ENHANCE_YOUR_CALM = new Http2ErrorCode(11, "ENHANCE_YOUR_CALM");
    public static final Http2ErrorCode INADEQUATE_SECURITY = new Http2ErrorCode(12, "INADEQUATE_SECURITY");
    public static final Http2ErrorCode HTTP_1_1_REQUIRED = new Http2ErrorCode(13, "HTTP_1_1_REQUIRED");
    private final int errorCode;
    private final String name;
    private static final Http2ErrorCode[] INT_TO_ENUM_MAP;

    private Http2ErrorCode(int errorCode, String name) {
        this.errorCode = errorCode;
        this.name = Objects.requireNonNull(name);
    }

    public int code() {
        return this.errorCode;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.errorCode;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Http2ErrorCode && this.errorCode == ((Http2ErrorCode)o).errorCode;
    }

    @Nullable
    public static Http2ErrorCode of(int errorCode) {
        return errorCode >= INT_TO_ENUM_MAP.length || errorCode < 0 ? null : INT_TO_ENUM_MAP[errorCode];
    }

    public static Http2ErrorCode of(int errorCode, String name) {
        return new Http2ErrorCode(errorCode, name);
    }

    static {
        Http2ErrorCode[] errors = new Http2ErrorCode[]{NO_ERROR, PROTOCOL_ERROR, INTERNAL_ERROR, FLOW_CONTROL_ERROR, SETTINGS_TIMEOUT, STREAM_CLOSED, FRAME_SIZE_ERROR, REFUSED_STREAM, CANCEL, COMPRESSION_ERROR, CONNECT_ERROR, ENHANCE_YOUR_CALM, INADEQUATE_SECURITY, HTTP_1_1_REQUIRED};
        Http2ErrorCode[] map = new Http2ErrorCode[errors.length];
        Http2ErrorCode[] http2ErrorCodeArray = errors;
        int n = http2ErrorCodeArray.length;
        for (int i = 0; i < n; ++i) {
            Http2ErrorCode error;
            map[error.code()] = error = http2ErrorCodeArray[i];
        }
        INT_TO_ENUM_MAP = map;
    }
}

