/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.wkb;

import java.io.IOException;
import java.nio.ByteOrder;
import mil.nga.sf.CircularString;
import mil.nga.sf.CompoundCurve;
import mil.nga.sf.Curve;
import mil.nga.sf.CurvePolygon;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryCollection;
import mil.nga.sf.GeometryType;
import mil.nga.sf.LineString;
import mil.nga.sf.MultiLineString;
import mil.nga.sf.MultiPoint;
import mil.nga.sf.MultiPolygon;
import mil.nga.sf.Point;
import mil.nga.sf.Polygon;
import mil.nga.sf.PolyhedralSurface;
import mil.nga.sf.TIN;
import mil.nga.sf.Triangle;
import mil.nga.sf.util.ByteWriter;
import mil.nga.sf.util.SFException;
import mil.nga.sf.wkb.GeometryCodes;

public class GeometryWriter {
    private ByteWriter writer;

    public static byte[] writeGeometry(Geometry geometry) throws IOException {
        return GeometryWriter.writeGeometry(geometry, ByteWriter.DEFAULT_BYTE_ORDER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] writeGeometry(Geometry geometry, ByteOrder byteOrder) throws IOException {
        byte[] bytes = null;
        try (GeometryWriter writer = new GeometryWriter(byteOrder);){
            writer.write(geometry);
            bytes = writer.getBytes();
        }
        return bytes;
    }

    public GeometryWriter() {
        this(ByteWriter.DEFAULT_BYTE_ORDER);
    }

    public GeometryWriter(ByteOrder byteOrder) {
        this(new ByteWriter(byteOrder));
    }

    public GeometryWriter(ByteWriter writer) {
        this.writer = writer;
    }

    public ByteWriter getByteWriter() {
        return this.writer;
    }

    public byte[] getBytes() {
        return this.writer.getBytes();
    }

    public void close() {
        this.writer.close();
    }

    public void write(Geometry geometry) throws IOException {
        byte byteOrder = this.writer.getByteOrder() == ByteOrder.BIG_ENDIAN ? (byte)0 : 1;
        this.writer.writeByte(byteOrder);
        this.writer.writeInt(GeometryCodes.getCode(geometry));
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case GEOMETRY: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case POINT: {
                this.writePoint((Point)geometry);
                break;
            }
            case LINESTRING: {
                this.writeLineString((LineString)geometry);
                break;
            }
            case POLYGON: {
                this.writePolygon((Polygon)geometry);
                break;
            }
            case MULTIPOINT: {
                this.writeMultiPoint((MultiPoint)geometry);
                break;
            }
            case MULTILINESTRING: {
                this.writeMultiLineString((MultiLineString)geometry);
                break;
            }
            case MULTIPOLYGON: {
                this.writeMultiPolygon((MultiPolygon)geometry);
                break;
            }
            case GEOMETRYCOLLECTION: 
            case MULTICURVE: 
            case MULTISURFACE: {
                this.writeGeometryCollection((GeometryCollection)geometry);
                break;
            }
            case CIRCULARSTRING: {
                this.writeCircularString((CircularString)geometry);
                break;
            }
            case COMPOUNDCURVE: {
                this.writeCompoundCurve((CompoundCurve)geometry);
                break;
            }
            case CURVEPOLYGON: {
                this.writeCurvePolygon((CurvePolygon)geometry);
                break;
            }
            case CURVE: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case SURFACE: {
                throw new SFException("Unexpected Geometry Type of " + geometryType.name() + " which is abstract");
            }
            case POLYHEDRALSURFACE: {
                this.writePolyhedralSurface((PolyhedralSurface)geometry);
                break;
            }
            case TIN: {
                this.writeTIN((TIN)geometry);
                break;
            }
            case TRIANGLE: {
                this.writeTriangle((Triangle)geometry);
                break;
            }
            default: {
                throw new SFException("Geometry Type not supported: " + geometryType);
            }
        }
    }

    public void writePoint(Point point) throws IOException {
        this.writeXY(point);
        this.writeZ(point);
        this.writeM(point);
    }

    public void writeXY(Point point) throws IOException {
        this.writer.writeDouble(point.getX());
        this.writer.writeDouble(point.getY());
    }

    public void writeZ(Point point) throws IOException {
        if (point.hasZ()) {
            this.writer.writeDouble(point.getZ().doubleValue());
        }
    }

    public void writeM(Point point) throws IOException {
        if (point.hasM()) {
            this.writer.writeDouble(point.getM().doubleValue());
        }
    }

    public void writeLineString(LineString lineString) throws IOException {
        this.writer.writeInt(lineString.numPoints());
        for (Point point : lineString.getPoints()) {
            this.writePoint(point);
        }
    }

    public void writePolygon(Polygon polygon) throws IOException {
        this.writer.writeInt(polygon.numRings());
        for (LineString ring : polygon.getRings()) {
            this.writeLineString(ring);
        }
    }

    public void writeMultiPoint(MultiPoint multiPoint) throws IOException {
        this.writer.writeInt(multiPoint.numPoints());
        for (Point point : multiPoint.getPoints()) {
            this.write((Geometry)point);
        }
    }

    public void writeMultiLineString(MultiLineString multiLineString) throws IOException {
        this.writer.writeInt(multiLineString.numLineStrings());
        for (LineString lineString : multiLineString.getLineStrings()) {
            this.write((Geometry)lineString);
        }
    }

    public void writeMultiPolygon(MultiPolygon multiPolygon) throws IOException {
        this.writer.writeInt(multiPolygon.numPolygons());
        for (Polygon polygon : multiPolygon.getPolygons()) {
            this.write((Geometry)polygon);
        }
    }

    public void writeGeometryCollection(GeometryCollection<?> geometryCollection) throws IOException {
        this.writer.writeInt(geometryCollection.numGeometries());
        for (Geometry geometry : geometryCollection.getGeometries()) {
            this.write(geometry);
        }
    }

    public void writeCircularString(CircularString circularString) throws IOException {
        this.writer.writeInt(circularString.numPoints());
        for (Point point : circularString.getPoints()) {
            this.writePoint(point);
        }
    }

    public void writeCompoundCurve(CompoundCurve compoundCurve) throws IOException {
        this.writer.writeInt(compoundCurve.numLineStrings());
        for (LineString lineString : compoundCurve.getLineStrings()) {
            this.write((Geometry)lineString);
        }
    }

    public void writeCurvePolygon(CurvePolygon<?> curvePolygon) throws IOException {
        this.writer.writeInt(curvePolygon.numRings());
        for (Curve ring : curvePolygon.getRings()) {
            this.write((Geometry)ring);
        }
    }

    public void writePolyhedralSurface(PolyhedralSurface polyhedralSurface) throws IOException {
        this.writer.writeInt(polyhedralSurface.numPolygons());
        for (Polygon polygon : polyhedralSurface.getPolygons()) {
            this.write((Geometry)polygon);
        }
    }

    public void writeTIN(TIN tin) throws IOException {
        this.writer.writeInt(tin.numPolygons());
        for (Polygon polygon : tin.getPolygons()) {
            this.write((Geometry)polygon);
        }
    }

    public void writeTriangle(Triangle triangle) throws IOException {
        this.writer.writeInt(triangle.numRings());
        for (LineString ring : triangle.getRings()) {
            this.writeLineString(ring);
        }
    }

    public static void writeGeometry(ByteWriter writer, Geometry geometry) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.write(geometry);
    }

    public static void writePoint(ByteWriter writer, Point point) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writePoint(point);
    }

    public static void writeLineString(ByteWriter writer, LineString lineString) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeLineString(lineString);
    }

    public static void writePolygon(ByteWriter writer, Polygon polygon) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writePolygon(polygon);
    }

    public static void writeMultiPoint(ByteWriter writer, MultiPoint multiPoint) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeMultiPoint(multiPoint);
    }

    public static void writeMultiLineString(ByteWriter writer, MultiLineString multiLineString) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeMultiLineString(multiLineString);
    }

    public static void writeMultiPolygon(ByteWriter writer, MultiPolygon multiPolygon) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeMultiPolygon(multiPolygon);
    }

    public static void writeGeometryCollection(ByteWriter writer, GeometryCollection<?> geometryCollection) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeGeometryCollection(geometryCollection);
    }

    public static void writeCircularString(ByteWriter writer, CircularString circularString) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeCircularString(circularString);
    }

    public static void writeCompoundCurve(ByteWriter writer, CompoundCurve compoundCurve) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeCompoundCurve(compoundCurve);
    }

    public static void writeCurvePolygon(ByteWriter writer, CurvePolygon<?> curvePolygon) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeCurvePolygon(curvePolygon);
    }

    public static void writePolyhedralSurface(ByteWriter writer, PolyhedralSurface polyhedralSurface) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writePolyhedralSurface(polyhedralSurface);
    }

    public static void writeTIN(ByteWriter writer, TIN tin) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeTIN(tin);
    }

    public static void writeTriangle(ByteWriter writer, Triangle triangle) throws IOException {
        GeometryWriter geometryWriter = new GeometryWriter(writer);
        geometryWriter.writeTriangle(triangle);
    }
}

