/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.dns.discovery.netty;

import io.netty.channel.EventLoop;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsCacheEntry;
import io.servicetalk.concurrent.TimeSource;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MinTtlCache
implements DnsCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinTtlCache.class);
    private final DnsCache cache;
    private final long initialTtl;
    private final Map<String, Long> minExpiryMap = new HashMap<String, Long>();
    private final TimeSource timeSource;

    MinTtlCache(DnsCache cache, long initialTtl, TimeSource timeSource) {
        this.cache = cache;
        this.initialTtl = initialTtl;
        this.timeSource = timeSource;
    }

    void prepareForResolution(String hostname) {
        this.minExpiryMap.remove(hostname);
    }

    long minTtl(String hostname) {
        Long minExpiry = this.minExpiryMap.get(hostname);
        if (minExpiry == null) {
            return this.initialTtl;
        }
        long minTtl = minExpiry - this.timeSource.currentTime(TimeUnit.SECONDS);
        return minTtl >= 0L ? minTtl : this.initialTtl;
    }

    public void clear() {
        this.cache.clear();
        this.minExpiryMap.clear();
    }

    public boolean clear(String hostname) {
        return this.cache.clear(hostname);
    }

    @Nullable
    public List<? extends DnsCacheEntry> get(String hostname, DnsRecord[] additionals) {
        List entries = this.cache.get(hostname, additionals);
        if (entries != null && !entries.isEmpty()) {
            LOGGER.debug("Found cached entries for {}: {}", (Object)hostname, (Object)entries);
        }
        return entries;
    }

    public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, InetAddress address, long originalTtl, EventLoop loop) {
        long currentTime = this.timeSource.currentTime(TimeUnit.SECONDS);
        this.minExpiryMap.merge(hostname, currentTime + Math.max(this.initialTtl, originalTtl), Math::min);
        return this.cache.cache(hostname, additionals, address, originalTtl, loop);
    }

    public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, Throwable cause, EventLoop loop) {
        return this.cache.cache(hostname, additionals, cause, loop);
    }
}

