/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.ipresource;

import java.math.BigInteger;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.Ipv4Address;
import net.ripe.ipresource.Ipv6Address;
import net.ripe.ipresource.UniqueIpResource;

public enum IpResourceType {
    ASN("Autonomous System Number", 32){

        @Override
        public boolean allowPrefixNotation() {
            return false;
        }

        @Override
        public UniqueIpResource fromBigInteger(BigInteger value) {
            return new Asn(value.longValue());
        }
    }
    ,
    IPv4("IPv4 Address", 32){

        @Override
        public UniqueIpResource fromBigInteger(BigInteger value) {
            return new Ipv4Address(value.longValue());
        }
    }
    ,
    IPv6("IPv6 Address", 128){

        @Override
        public UniqueIpResource fromBigInteger(BigInteger value) {
            return new Ipv6Address(value);
        }
    };

    private final String description;
    private final int bitSize;

    private IpResourceType(String description, int bitSize) {
        this.description = description;
        this.bitSize = bitSize;
    }

    public String getCode() {
        return this.name();
    }

    public String getDescription() {
        return this.description;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    public boolean allowPrefixNotation() {
        return true;
    }

    public UniqueIpResource getMinimum() {
        return this.fromBigInteger(BigInteger.ZERO);
    }

    public UniqueIpResource getMaximum() {
        return this.fromBigInteger(BigInteger.ONE.shiftLeft(this.getBitSize()).subtract(BigInteger.ONE));
    }

    public abstract UniqueIpResource fromBigInteger(BigInteger var1);

    public static IpResourceType parse(String s) {
        return IpResourceType.valueOf(s);
    }
}

