/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.logging.slf4j.internal;

import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.logging.slf4j.internal.DebugLogger;
import io.servicetalk.logging.slf4j.internal.ErrorLogger;
import io.servicetalk.logging.slf4j.internal.FixedLevelLogger;
import io.servicetalk.logging.slf4j.internal.InfoLogger;
import io.servicetalk.logging.slf4j.internal.TraceLogger;
import io.servicetalk.logging.slf4j.internal.WarnLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Slf4jFixedLevelLoggers {
    private Slf4jFixedLevelLoggers() {
    }

    public static FixedLevelLogger newLogger(String loggerName, LogLevel level) {
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        switch (level) {
            case TRACE: {
                return new TraceLogger(logger);
            }
            case DEBUG: {
                return new DebugLogger(logger);
            }
            case INFO: {
                return new InfoLogger(logger);
            }
            case WARN: {
                return new WarnLogger(logger);
            }
            case ERROR: {
                return new ErrorLogger(logger);
            }
        }
        throw new IllegalArgumentException("unsupported level: " + level);
    }
}

