/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.OnSubscribeIgnoringSubscriberForOffloading;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.ScanWithMapper;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class ScanWithPublisher<T, R>
extends AbstractNoHandleSubscribePublisher<R> {
    private final Publisher<T> original;
    private final Supplier<? extends ScanWithMapper<? super T, ? extends R>> mapperSupplier;

    ScanWithPublisher(Publisher<T> original, Supplier<R> initial, BiFunction<R, ? super T, R> accumulator) {
        this(original, new SupplierScanWithMapper<T, R>(initial, accumulator));
    }

    ScanWithPublisher(Publisher<T> original, Supplier<? extends ScanWithMapper<? super T, ? extends R>> mapperSupplier) {
        this.mapperSupplier = Objects.requireNonNull(mapperSupplier);
        this.original = original;
    }

    @Override
    ContextMap contextForSubscribe(AsyncContextProvider provider) {
        return provider.context();
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super R> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ScanWithSubscriber<T, R>(subscriber, this.mapperSupplier.get(), contextProvider, contextMap), contextMap, contextProvider);
    }

    private static final class SupplierScanWithMapper<T, R>
    implements Supplier<ScanWithMapper<T, R>> {
        private final BiFunction<R, ? super T, R> accumulator;
        private final Supplier<R> initial;

        SupplierScanWithMapper(Supplier<R> initial, BiFunction<R, ? super T, R> accumulator) {
            this.initial = Objects.requireNonNull(initial);
            this.accumulator = Objects.requireNonNull(accumulator);
        }

        @Override
        public ScanWithMapper<T, R> get() {
            return new ScanWithMapper<T, R>(){
                @Nullable
                private R state;
                {
                    this.state = initial.get();
                }

                @Override
                public R mapOnNext(@Nullable T next) {
                    this.state = accumulator.apply(this.state, next);
                    return this.state;
                }

                @Override
                public R mapOnError(Throwable cause) {
                    throw SupplierScanWithMapper.newMapTerminalUnsupported();
                }

                @Override
                public R mapOnComplete() {
                    throw SupplierScanWithMapper.newMapTerminalUnsupported();
                }

                @Override
                public boolean mapTerminal() {
                    return false;
                }
            };
        }

        private static IllegalStateException newMapTerminalUnsupported() {
            throw new IllegalStateException("mapTerminal returns false, this method should never be invoked!");
        }
    }

    static class ScanWithSubscriber<T, R>
    implements PublisherSource.Subscriber<T> {
        private static final AtomicLongFieldUpdater<ScanWithSubscriber> demandUpdater = AtomicLongFieldUpdater.newUpdater(ScanWithSubscriber.class, "demand");
        private static final long TERMINATED = Long.MIN_VALUE;
        private static final long TERMINAL_PENDING = -9223372036854775807L;
        private static final long INVALID_DEMAND = -1L;
        private final PublisherSource.Subscriber<? super R> subscriber;
        private final ContextMap contextMap;
        private final AsyncContextProvider contextProvider;
        private final ScanWithMapper<? super T, ? extends R> mapper;
        private volatile long demand;
        @Nullable
        private Throwable errorCause;

        ScanWithSubscriber(PublisherSource.Subscriber<? super R> subscriber, ScanWithMapper<? super T, ? extends R> mapper, AsyncContextProvider contextProvider, ContextMap contextMap) {
            this.subscriber = subscriber;
            this.contextProvider = contextProvider;
            this.contextMap = contextMap;
            this.mapper = Objects.requireNonNull(mapper);
        }

        public void onSubscribe(PublisherSource.Subscription subscription) {
            this.subscriber.onSubscribe(this.newSubscription(subscription));
        }

        private PublisherSource.Subscription newSubscription(final PublisherSource.Subscription subscription) {
            return new PublisherSource.Subscription(){

                public void request(long n) {
                    if (!SubscriberUtils.isRequestNValid((long)n)) {
                        this.handleInvalidDemand(n);
                    } else if (demandUpdater.getAndAccumulate(this, n, FlowControlUtils::addWithOverflowProtectionIfNotNegative) == -9223372036854775807L) {
                        demand = Long.MIN_VALUE;
                        if (errorCause != null) {
                            this.deliverOnErrorFromSubscription(errorCause, this.newOffloadedSubscriber());
                        } else {
                            this.deliverOnCompleteFromSubscription(this.newOffloadedSubscriber());
                        }
                    } else {
                        subscription.request(n);
                    }
                }

                public void cancel() {
                    subscription.cancel();
                    this.onCancel();
                }

                private void handleInvalidDemand(long n) {
                    if (demandUpdater.getAndSet(this, -1L) == -9223372036854775807L) {
                        demand = Long.MIN_VALUE;
                        this.newOffloadedSubscriber().onError((Throwable)SubscriberUtils.newExceptionForInvalidRequestN((long)n));
                    } else {
                        subscription.request(n);
                    }
                }

                private PublisherSource.Subscriber<? super R> newOffloadedSubscriber() {
                    return OnSubscribeIgnoringSubscriberForOffloading.wrapWithDummyOnSubscribe(subscriber, contextMap, contextProvider);
                }
            };
        }

        public void onNext(@Nullable T t) {
            R mapped = this.mapper.mapOnNext(t);
            demandUpdater.decrementAndGet(this);
            this.subscriber.onNext(mapped);
        }

        public void onError(Throwable t) {
            this.onError0(t);
        }

        public void onComplete() {
            this.onComplete0();
        }

        protected boolean onError0(Throwable t) {
            block6: {
                boolean doMap;
                this.errorCause = t;
                try {
                    doMap = this.mapper.mapTerminal();
                }
                catch (Throwable cause) {
                    this.subscriber.onError(cause);
                    return true;
                }
                if (doMap) {
                    long currDemand;
                    do {
                        if ((currDemand = this.demand) > 0L && demandUpdater.compareAndSet(this, currDemand, Long.MIN_VALUE)) {
                            this.deliverOnError(t, this.subscriber);
                            break block6;
                        }
                        if (currDemand != 0L || !demandUpdater.compareAndSet(this, currDemand, -9223372036854775807L)) continue;
                        return false;
                    } while (currDemand >= 0L);
                    this.subscriber.onError(t);
                } else {
                    this.demand = Long.MIN_VALUE;
                    this.subscriber.onError(t);
                }
            }
            return true;
        }

        protected boolean onComplete0() {
            block6: {
                boolean doMap;
                try {
                    doMap = this.mapper.mapTerminal();
                }
                catch (Throwable cause) {
                    this.subscriber.onError(cause);
                    return true;
                }
                if (doMap) {
                    long currDemand;
                    do {
                        if ((currDemand = this.demand) > 0L && demandUpdater.compareAndSet(this, currDemand, Long.MIN_VALUE)) {
                            this.deliverOnComplete(this.subscriber);
                            break block6;
                        }
                        if (currDemand != 0L || !demandUpdater.compareAndSet(this, currDemand, -9223372036854775807L)) continue;
                        return false;
                    } while (currDemand >= 0L);
                    this.subscriber.onError((Throwable)new IllegalStateException("onComplete with invalid demand: " + currDemand));
                } else {
                    this.demand = Long.MIN_VALUE;
                    this.subscriber.onComplete();
                }
            }
            return true;
        }

        protected void onCancel() {
        }

        protected void deliverOnErrorFromSubscription(Throwable t, PublisherSource.Subscriber<? super R> subscriber) {
            this.deliverOnError(t, subscriber);
        }

        protected void deliverOnCompleteFromSubscription(PublisherSource.Subscriber<? super R> subscriber) {
            this.deliverOnComplete(subscriber);
        }

        private void deliverOnError(Throwable t, PublisherSource.Subscriber<? super R> subscriber) {
            try {
                subscriber.onNext(this.mapper.mapOnError(t));
            }
            catch (Throwable cause) {
                subscriber.onError(cause);
                return;
            }
            subscriber.onComplete();
        }

        private void deliverOnComplete(PublisherSource.Subscriber<? super R> subscriber) {
            try {
                subscriber.onNext(this.mapper.mapOnComplete());
            }
            catch (Throwable cause) {
                subscriber.onError(cause);
                return;
            }
            subscriber.onComplete();
        }
    }
}

