/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.CopyOnWriteContextMap;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.context.api.ContextMapHolder;

final class AsyncContextMapThreadLocal {
    static final ThreadLocal<ContextMap> CONTEXT_THREAD_LOCAL = ThreadLocal.withInitial(AsyncContextMapThreadLocal::newContextMap);

    AsyncContextMapThreadLocal() {
    }

    private static ContextMap newContextMap() {
        return new CopyOnWriteContextMap();
    }

    ContextMap get() {
        Thread t = Thread.currentThread();
        if (t instanceof ContextMapHolder) {
            ContextMapHolder contextMapHolder = (ContextMapHolder)t;
            ContextMap map = contextMapHolder.context();
            if (map == null) {
                map = AsyncContextMapThreadLocal.newContextMap();
                contextMapHolder.context(map);
            }
            return map;
        }
        return CONTEXT_THREAD_LOCAL.get();
    }
}

