/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeCompletable;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.context.api.ContextMap;

abstract class AbstractPubToCompletable<T>
extends AbstractNoHandleSubscribeCompletable {
    private final Publisher<T> source;

    AbstractPubToCompletable(Publisher<T> source) {
        this.source = source;
    }

    abstract PublisherSource.Subscriber<T> newSubscriber(CompletableSource.Subscriber var1);

    @Override
    final void handleSubscribe(CompletableSource.Subscriber subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        PublisherSource.Subscriber<T> wrappedSubscriber = contextProvider.wrapSubscription(this.newSubscriber(subscriber), contextMap);
        this.source.delegateSubscribe(wrappedSubscriber, contextMap, contextProvider);
    }

    static abstract class AbstractPubToCompletableSubscriber<T>
    extends DelayedCancellable
    implements PublisherSource.Subscriber<T> {
        private final CompletableSource.Subscriber subscriber;

        AbstractPubToCompletableSubscriber(CompletableSource.Subscriber subscriber) {
            this.subscriber = subscriber;
        }

        public final void onSubscribe(PublisherSource.Subscription s) {
            this.subscriber.onSubscribe((Cancellable)this);
            s.request(Long.MAX_VALUE);
            this.delayedCancellable((Cancellable)s);
        }

        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

