/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import mil.nga.crs.common.Identifiable;
import mil.nga.crs.common.Identifier;
import mil.nga.crs.operation.OperationMethods;
import mil.nga.crs.operation.OperationParameter;
import mil.nga.crs.wkt.CRSWriter;

public class OperationMethod
implements Identifiable {
    private static final Logger logger = Logger.getLogger(OperationMethod.class.getName());
    private String name = null;
    private List<OperationParameter> parameters = null;
    private List<Identifier> identifiers = null;
    private OperationMethods method;

    public OperationMethod() {
    }

    public OperationMethod(String name) {
        this.name = name;
        this.updateMethod();
    }

    public OperationMethod(OperationMethods method) {
        this.name = method.getName();
        this.method = method;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.updateMethod();
    }

    public List<OperationParameter> getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    public int numParameters() {
        return this.parameters != null ? this.parameters.size() : 0;
    }

    public OperationParameter getParameter(int index) {
        return this.parameters.get(index);
    }

    public void setParameters(List<OperationParameter> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(OperationParameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<OperationParameter>();
        }
        this.parameters.add(parameter);
    }

    public void addParameters(List<OperationParameter> parameters) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<OperationParameter>();
        }
        this.parameters.addAll(parameters);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public boolean hasIdentifiers() {
        return this.identifiers != null && !this.identifiers.isEmpty();
    }

    @Override
    public int numIdentifiers() {
        return this.identifiers != null ? this.identifiers.size() : 0;
    }

    @Override
    public Identifier getIdentifier(int index) {
        return this.identifiers.get(index);
    }

    @Override
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public void addIdentifier(Identifier identifier) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.add(identifier);
    }

    @Override
    public void addIdentifiers(List<Identifier> identifiers) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.addAll(identifiers);
    }

    public OperationMethods getMethod() {
        return this.method;
    }

    public boolean hasMethod() {
        return this.getMethod() != null;
    }

    public void setMethod(OperationMethods method) {
        this.method = method;
    }

    public void updateMethod() {
        this.setMethod(OperationMethods.getMethod(this.getName()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifiers == null ? 0 : this.identifiers.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperationMethod other = (OperationMethod)obj;
        if (this.identifiers == null ? other.identifiers != null : !this.identifiers.equals(other.identifiers)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String value = null;
        try (CRSWriter writer = new CRSWriter();){
            writer.write(this);
            value = writer.toString();
        }
        return value;
    }
}

