/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.cli.exceptions;

import org.apache.ignite.migrationtools.persistence.mappers.RecordAndTableSchemaMismatchException;
import org.apache.ignite3.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite3.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite3.internal.cli.core.style.component.ErrorUiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElement;

public class RecordAndTableSchemaMismatchExceptionHandler
implements ExceptionHandler<RecordAndTableSchemaMismatchException> {
    public static final RecordAndTableSchemaMismatchExceptionHandler INSTANCE = new RecordAndTableSchemaMismatchExceptionHandler();

    public int handle(ExceptionWriter writer, RecordAndTableSchemaMismatchException e) {
        writer.write(ErrorUiComponent.builder().header("Error while migrating cache.", new UiElement[0]).details(RecordAndTableSchemaMismatchExceptionHandler.details(e), new UiElement[0]).build().render());
        return 1;
    }

    public static String details(RecordAndTableSchemaMismatchException e) {
        StringBuilder msgBuilder = new StringBuilder();
        msgBuilder.append("Mismatch between cache records and the target table definition.\nAt least one record in the cache was not compatible with the target table definition.");
        if (!e.missingColumnsInRecord().isEmpty()) {
            msgBuilder.append("\nRecord did not have the following fields required by the table: ").append(String.join((CharSequence)", ", e.missingColumnsInRecord())).append("\nConsider the following solutions:").append("\n * Manually edit the Ignite 3 table schema to make the missing columns nullable.");
        }
        if (!e.additionalColumnsInRecord().isEmpty()) {
            msgBuilder.append("\nThe following fields were present on the record but not found in the table: ").append(String.join((CharSequence)", ", e.additionalColumnsInRecord())).append("\nConsider the following solutions:").append("\n * Manual Editing: Edit the Ignite 3 table schema manually to add new columns for the additional fields. Ensure that the new column types are compatible with the record type.").append("\n * Ignore Additional Fields: Use the IGNORE_COLUMN migration mode by applying the '--mode IGNORE_COLUMN' option. This approach will skip the migration of those columns, resulting in the loss of their content.").append("\n * Store as JSON: Use the '--mode PACK_EXTRA' option to store additional fields as JSON in an extra column. While Ignite 3 does not natively support unmarshalling the original record from this column, it can be accessed by another application to retrieve the information contained in these additional fields.");
        }
        return msgBuilder.toString();
    }

    public Class<RecordAndTableSchemaMismatchException> applicableException() {
        return RecordAndTableSchemaMismatchException.class;
    }
}

