/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.failover.jobstealing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiConsistencyChecked;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMBeanAdapter;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.failover.FailoverContext;
import org.apache.ignite.spi.failover.FailoverSpi;
import org.apache.ignite.spi.failover.jobstealing.JobStealingFailoverSpiMBean;

@IgniteSpiMultipleInstancesSupport(value=true)
@IgniteSpiConsistencyChecked(optional=true)
public class JobStealingFailoverSpi
extends IgniteSpiAdapter
implements FailoverSpi {
    public static final int DFLT_MAX_FAILOVER_ATTEMPTS = 5;
    static final String FAILED_NODE_LIST_ATTR = "gg:failover:failednodelist";
    static final String FAILOVER_ATTEMPT_COUNT_ATTR = "gg:failover:attemptcount";
    private static final String MAX_FAILOVER_ATTEMPT_ATTR = "gg:failover:maxattempts";
    @LoggerResource
    private IgniteLogger log;
    private int maxFailoverAttempts = 5;
    private int totalFailedOverJobs;
    private int totalStolenJobs;

    public int getMaximumFailoverAttempts() {
        return this.maxFailoverAttempts;
    }

    @IgniteSpiConfiguration(optional=true)
    public JobStealingFailoverSpi setMaximumFailoverAttempts(int maxFailoverAttempts) {
        this.maxFailoverAttempts = maxFailoverAttempts;
        return this;
    }

    public int getTotalFailedOverJobsCount() {
        return this.totalFailedOverJobs;
    }

    public int getTotalStolenJobsCount() {
        return this.totalStolenJobs;
    }

    @Override
    public Map<String, Object> getNodeAttributes() throws IgniteSpiException {
        return F.asMap(this.createSpiAttributeName(MAX_FAILOVER_ATTEMPT_ATTR), this.maxFailoverAttempts);
    }

    @Override
    public void spiStart(String igniteInstanceName) throws IgniteSpiException {
        this.startStopwatch();
        this.assertParameter(this.maxFailoverAttempts >= 0, "maximumFailoverAttempts >= 0");
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.configInfo("maxFailoverAttempts", this.maxFailoverAttempts));
        }
        this.registerMBean(igniteInstanceName, new JobStealingFailoverSpiMBeanImpl(this), JobStealingFailoverSpiMBean.class);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        this.unregisterMBean();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    @Override
    public ClusterNode failover(FailoverContext ctx, List<ClusterNode> top) {
        assert (ctx != null);
        assert (top != null);
        if (top.isEmpty()) {
            U.warn(this.log, "Received empty subgrid and is forced to fail.");
            return null;
        }
        Integer failoverCnt = (Integer)ctx.getJobResult().getJobContext().getAttribute(FAILOVER_ATTEMPT_COUNT_ATTR);
        if (failoverCnt == null) {
            failoverCnt = 0;
        }
        if (failoverCnt > this.maxFailoverAttempts) {
            U.error(this.log, "Failover count exceeded maximum failover attempts parameter [failedJob=" + ctx.getJobResult().getJob() + ", maxFailoverAttempts=" + this.maxFailoverAttempts + "]");
            return null;
        }
        if (failoverCnt == this.maxFailoverAttempts) {
            U.warn(this.log, "Job failover failed because number of maximum failover attempts is exceeded [failedJob=" + ctx.getJobResult().getJob() + ", maxFailoverAttempts=" + this.maxFailoverAttempts + "]");
            return null;
        }
        try {
            ClusterNode thief = null;
            boolean isNodeFailed = false;
            UUID thiefId = (UUID)ctx.getJobResult().getJobContext().getAttribute("ignite.collision.thief.node");
            if (thiefId != null) {
                ctx.getJobResult().getJobContext().setAttribute("ignite.collision.thief.node", null);
                thief = this.getSpiContext().node(thiefId);
                if (thief != null) {
                    if (thief.equals(ctx.getJobResult().getNode())) {
                        U.error(this.log, "Job stealer node is equal to job node (will fail-over using load-balancing): " + thief.id());
                        isNodeFailed = true;
                        thief = null;
                    } else if (!top.contains(thief)) {
                        U.warn(this.log, "Thief node is not part of task topology  (will fail-over using load-balancing) [thief=" + thiefId + ", topSize=" + top.size() + "]");
                        thief = null;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Failing-over stolen job [from=" + ctx.getJobResult().getNode() + ", to=" + thief + "]");
                    }
                } else {
                    isNodeFailed = true;
                    U.warn(this.log, "Thief node left grid (will fail-over using load balancing): " + thiefId);
                }
            } else {
                isNodeFailed = true;
            }
            if (thief == null) {
                HashSet failedNodes = (HashSet)ctx.getJobResult().getJobContext().getAttribute(FAILED_NODE_LIST_ATTR);
                if (failedNodes == null) {
                    failedNodes = U.newHashSet(1);
                }
                if (isNodeFailed) {
                    failedNodes.add(ctx.getJobResult().getNode().id());
                }
                ctx.getJobResult().getJobContext().setAttribute(FAILED_NODE_LIST_ATTR, failedNodes);
                ArrayList<ClusterNode> newTop = new ArrayList<ClusterNode>(top.size());
                for (ClusterNode n : top) {
                    if (failedNodes.contains(n.id())) continue;
                    newTop.add(n);
                }
                if (newTop.isEmpty()) {
                    U.warn(this.log, "Received topology with only nodes that job had failed on (forced to fail) [failedNodes=" + failedNodes + "]");
                    return null;
                }
                thief = ctx.getBalancedNode(newTop);
                if (thief == null) {
                    U.warn(this.log, "Load balancer returned null node for topology: " + newTop);
                }
            }
            if (isNodeFailed) {
                Integer n = failoverCnt;
                Integer n2 = failoverCnt = Integer.valueOf(failoverCnt + 1);
            }
            ctx.getJobResult().getJobContext().setAttribute(FAILOVER_ATTEMPT_COUNT_ATTR, failoverCnt);
            if (thief != null) {
                ++this.totalFailedOverJobs;
                if (isNodeFailed) {
                    U.warn(this.log, "Failed over job to a new node [newNode=" + thief.id() + ", oldNode=" + ctx.getJobResult().getNode().id() + ", sesId=" + ctx.getTaskSession().getId() + ", job=" + ctx.getJobResult().getJob() + ", jobCtx=" + ctx.getJobResult().getJobContext() + ", task=" + ctx.getTaskSession().getTaskName() + "]");
                } else {
                    ++this.totalStolenJobs;
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Stealing job to a new node [newNode=" + thief.id() + ", oldNode=" + ctx.getJobResult().getNode().id() + ", sesId=" + ctx.getTaskSession().getId() + ", job=" + ctx.getJobResult().getJob() + ", jobCtx=" + ctx.getJobResult().getJobContext() + ", task=" + ctx.getTaskSession().getTaskName() + "]");
                    }
                }
            }
            return thief;
        }
        catch (IgniteException e) {
            U.error(this.log, "Failed to get next balanced node for failover: " + ctx, e);
            return null;
        }
    }

    @Override
    protected List<String> getConsistentAttributeNames() {
        return Collections.singletonList(this.createSpiAttributeName(MAX_FAILOVER_ATTEMPT_ATTR));
    }

    @Override
    public JobStealingFailoverSpi setName(String name) {
        super.setName(name);
        return this;
    }

    public String toString() {
        return S.toString(JobStealingFailoverSpi.class, this);
    }

    private class JobStealingFailoverSpiMBeanImpl
    extends IgniteSpiMBeanAdapter
    implements JobStealingFailoverSpiMBean {
        public JobStealingFailoverSpiMBeanImpl(IgniteSpiAdapter spiAdapter) {
            super(spiAdapter);
        }

        @Override
        public int getMaximumFailoverAttempts() {
            return JobStealingFailoverSpi.this.getMaximumFailoverAttempts();
        }

        @Override
        public int getTotalFailedOverJobsCount() {
            return JobStealingFailoverSpi.this.getTotalFailedOverJobsCount();
        }

        @Override
        public int getTotalStolenJobsCount() {
            return JobStealingFailoverSpi.this.getTotalStolenJobsCount();
        }
    }
}

