/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.hint;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum IgniteHint {
    DISABLE_RULE(true),
    ENFORCE_JOIN_ORDER,
    EXPAND_DISTINCT_AGG,
    NO_INDEX(true),
    FORCE_INDEX(true);

    private final boolean paramSupport;
    private static final Map<String, IgniteHint> ALL_HINTS_AS_MAP;

    private IgniteHint(boolean paramSupport) {
        this.paramSupport = paramSupport;
    }

    private IgniteHint() {
        this(false);
    }

    public static IgniteHint get(String hintName) {
        return ALL_HINTS_AS_MAP.get(hintName);
    }

    public boolean paramSupport() {
        return this.paramSupport;
    }

    static {
        ALL_HINTS_AS_MAP = new HashMap<String, IgniteHint>();
        Arrays.stream(IgniteHint.values()).forEach(e -> ALL_HINTS_AS_MAP.put(e.name(), (IgniteHint)((Object)e)));
    }
}

