/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.segstore;

import java.util.Arrays;
import org.apache.ignite3.internal.raft.storage.segstore.IndexFileMeta;
import org.jetbrains.annotations.Nullable;

class IndexFileMetaArray {
    static final int INITIAL_CAPACITY = 10;
    private final IndexFileMeta[] array;
    private final int size;

    IndexFileMetaArray(IndexFileMeta initialMeta) {
        this.array = new IndexFileMeta[10];
        this.array[0] = initialMeta;
        this.size = 1;
    }

    private IndexFileMetaArray(IndexFileMeta[] array, int size) {
        this.array = array;
        this.size = size;
    }

    IndexFileMetaArray add(IndexFileMeta indexFileMeta) {
        assert (indexFileMeta.firstLogIndex() == this.array[this.size - 1].lastLogIndex() + 1L) : String.format("Index File Metas must be contiguous. Expected log index: %d, actual log index: %d", this.array[this.size - 1].lastLogIndex() + 1L, indexFileMeta.firstLogIndex());
        IndexFileMeta[] array = this.array;
        if (this.size == array.length) {
            array = Arrays.copyOf(array, array.length * 2);
        }
        array[this.size] = indexFileMeta;
        return new IndexFileMetaArray(array, this.size + 1);
    }

    IndexFileMeta get(int arrayIndex) {
        return this.array[arrayIndex];
    }

    int size() {
        return this.size;
    }

    @Nullable
    IndexFileMeta find(long logIndex) {
        int lowArrayIndex = 0;
        int highArrayIndex = this.size - 1;
        while (lowArrayIndex <= highArrayIndex) {
            int middleArrayIndex = lowArrayIndex + highArrayIndex >>> 1;
            IndexFileMeta midValue = this.array[middleArrayIndex];
            if (logIndex < midValue.firstLogIndex()) {
                highArrayIndex = middleArrayIndex - 1;
                continue;
            }
            if (logIndex > midValue.lastLogIndex()) {
                lowArrayIndex = middleArrayIndex + 1;
                continue;
            }
            return midValue;
        }
        return null;
    }
}

