/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.avatica.Helper;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.interpreter.Compiler;
import org.apache.calcite.interpreter.InterpretableConvention;
import org.apache.calcite.interpreter.InterpretableRel;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.FieldDeclaration;
import org.apache.calcite.linq4j.tree.Visitor;
import org.apache.calcite.linq4j.tree.VisitorImpl;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.runtime.ArrayBindable;
import org.apache.calcite.runtime.Bindable;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.runtime.Typed;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.ICompilerFactory;
import org.codehaus.commons.compiler.ISimpleCompiler;

public class EnumerableInterpretable
extends ConverterImpl
implements InterpretableRel {
    private static final Cache<String, Bindable> BINDABLE_CACHE = CacheBuilder.newBuilder().concurrencyLevel(CalciteSystemProperty.BINDABLE_CACHE_CONCURRENCY_LEVEL.value().intValue()).maximumSize((long)CalciteSystemProperty.BINDABLE_CACHE_MAX_SIZE.value().intValue()).build();

    protected EnumerableInterpretable(RelOptCluster cluster, RelNode input) {
        super(cluster, ConventionTraitDef.INSTANCE, cluster.traitSetOf((RelTrait)InterpretableConvention.INSTANCE), input);
    }

    @Override
    public EnumerableInterpretable copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableInterpretable(this.getCluster(), EnumerableInterpretable.sole(inputs));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public Node implement(InterpretableRel.InterpreterImplementor implementor) {
        Bindable bindable = EnumerableInterpretable.toBindable(implementor.internalParameters, implementor.spark, (EnumerableRel)this.getInput(), EnumerableRel.Prefer.ARRAY);
        ArrayBindable arrayBindable = EnumerableInterpretable.box(bindable);
        Enumerable<@Nullable T> enumerable = arrayBindable.bind(implementor.dataContext);
        return new EnumerableNode(enumerable, implementor.compiler, this);
    }

    public static Bindable toBindable(Map<String, Object> parameters,  @Nullable CalcitePrepare.SparkHandler spark, EnumerableRel rel, EnumerableRel.Prefer prefer) {
        EnumerableRelImplementor relImplementor = new EnumerableRelImplementor(rel.getCluster().getRexBuilder(), parameters);
        ClassDeclaration expr = relImplementor.implementRoot(rel, prefer);
        String s = Expressions.toString((List)expr.memberDeclarations, (String)"\n", (boolean)false);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            Util.debugCode(System.out, s);
        }
        Hook.JAVA_PLAN.run(s);
        try {
            if (spark != null && spark.enabled()) {
                return spark.compile(expr, s);
            }
            return EnumerableInterpretable.getBindable(expr, s, rel.getRowType().getFieldCount());
        }
        catch (Exception e) {
            throw Helper.INSTANCE.wrap("Error while compiling generated Java code:\n" + s, e);
        }
    }

    static Bindable getBindable(ClassDeclaration expr, String classBody, int fieldCount) throws CompileException, ExecutionException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ICompilerFactory compilerFactory;
        ClassLoader classLoader = Objects.requireNonNull(EnumerableInterpretable.class.getClassLoader(), "classLoader");
        try {
            compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory((ClassLoader)classLoader);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate java compiler", e);
        }
        ISimpleCompiler compiler = compilerFactory.newSimpleCompiler();
        compiler.setParentClassLoader(classLoader);
        String s = "public final class " + expr.name + " implements " + (fieldCount == 1 ? Bindable.class.getCanonicalName() + ", " + Typed.class.getCanonicalName() : ArrayBindable.class.getCanonicalName()) + " {\n" + classBody + "\n}";
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            compiler.setDebuggingInformation(true, true, true);
        }
        if (CalciteSystemProperty.BINDABLE_CACHE_MAX_SIZE.value() != 0) {
            StaticFieldDetector detector = new StaticFieldDetector();
            expr.accept((Visitor)detector);
            if (!detector.containsStaticField) {
                return (Bindable)BINDABLE_CACHE.get((Object)classBody, () -> EnumerableInterpretable.compileToBindable(expr.name, s, compiler));
            }
        }
        return EnumerableInterpretable.compileToBindable(expr.name, s, compiler);
    }

    private static Bindable<?> compileToBindable(String className, String s, ISimpleCompiler compiler) throws CompileException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        compiler.cook(s);
        return (Bindable)compiler.getClassLoader().loadClass(className).getDeclaredConstructors()[0].newInstance(new Object[0]);
    }

    static ArrayBindable box(final Bindable bindable) {
        if (bindable instanceof ArrayBindable) {
            return (ArrayBindable)bindable;
        }
        return new ArrayBindable(){

            @Override
            public Class<Object[]> getElementType() {
                return Object[].class;
            }

            @Override
            public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
                final Enumerable enumerable = bindable.bind(dataContext);
                return new AbstractEnumerable<Object[]>(){

                    public Enumerator<@Nullable Object[]> enumerator() {
                        final Enumerator enumerator = enumerable.enumerator();
                        return new Enumerator<Object[]>(){

                            public @Nullable Object[] current() {
                                return new Object[]{enumerator.current()};
                            }

                            public boolean moveNext() {
                                return enumerator.moveNext();
                            }

                            public void reset() {
                                enumerator.reset();
                            }

                            public void close() {
                                enumerator.close();
                            }
                        };
                    }
                };
            }
        };
    }

    private static class EnumerableNode
    implements Node {
        private final Enumerable<@Nullable Object[]> enumerable;
        private final Sink sink;

        EnumerableNode(Enumerable<@Nullable Object[]> enumerable, Compiler compiler, EnumerableInterpretable rel) {
            this.enumerable = enumerable;
            this.sink = compiler.sink(rel);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public void run() throws InterruptedException {
            @Nullable Enumerator enumerator = this.enumerable.enumerator();
            while (enumerator.moveNext()) {
                @Nullable Object[] values = (Object[])enumerator.current();
                this.sink.send(Row.of(values));
            }
        }
    }

    static class StaticFieldDetector
    extends VisitorImpl<Void> {
        boolean containsStaticField = false;

        StaticFieldDetector() {
        }

        public Void visit(FieldDeclaration fieldDeclaration) {
            this.containsStaticField |= (fieldDeclaration.modifier & 8) != 0;
            return this.containsStaticField ? null : (Void)super.visit(fieldDeclaration);
        }
    }
}

