/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UpdateCommandResult
implements Serializable {
    private static final long serialVersionUID = 2213057546590681613L;
    private final boolean primaryReplicaMatch;
    @Nullable
    private final Long currentLeaseStartTime;
    private final boolean primaryInPeersAndLearners;
    private final long safeTimestamp;

    public UpdateCommandResult(boolean primaryReplicaMatch, boolean primaryInPeersAndLearners, long safeTimestamp) {
        this(primaryReplicaMatch, null, primaryInPeersAndLearners, safeTimestamp);
    }

    public UpdateCommandResult(boolean primaryReplicaMatch, @Nullable Long currentLeaseStartTime, boolean primaryInPeersAndLearners, long safeTimestamp) {
        assert (primaryReplicaMatch || currentLeaseStartTime != null) : "Incorrect UpdateCommandResult.";
        this.primaryReplicaMatch = primaryReplicaMatch;
        this.currentLeaseStartTime = currentLeaseStartTime;
        this.primaryInPeersAndLearners = primaryInPeersAndLearners;
        this.safeTimestamp = safeTimestamp;
    }

    public boolean isPrimaryReplicaMatch() {
        return this.primaryReplicaMatch;
    }

    @Nullable
    public Long currentLeaseStartTime() {
        return this.currentLeaseStartTime;
    }

    public boolean isPrimaryInPeersAndLearners() {
        return this.primaryInPeersAndLearners;
    }

    public long safeTimestamp() {
        return this.safeTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateCommandResult that = (UpdateCommandResult)o;
        return this.primaryReplicaMatch == that.primaryReplicaMatch && this.primaryInPeersAndLearners == that.primaryInPeersAndLearners && Objects.equals(this.currentLeaseStartTime, that.currentLeaseStartTime);
    }

    public int hashCode() {
        return Objects.hash(this.primaryReplicaMatch, this.currentLeaseStartTime, this.primaryInPeersAndLearners);
    }
}

