/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;

public interface IgniteDataOutput
extends DataOutput {
    public void outputStream(OutputStream var1);

    public byte[] array();

    public byte[] internalArray();

    public int offset();

    public void offset(int var1);

    public void cleanup();

    public void writeVarInt(long var1) throws IOException;

    public void writeByteArray(byte[] var1) throws IOException;

    public void writeShortArray(short[] var1) throws IOException;

    public void writeIntArray(int[] var1) throws IOException;

    public void writeLongArray(long[] var1) throws IOException;

    public void writeFloatArray(float[] var1) throws IOException;

    public void writeDoubleArray(double[] var1) throws IOException;

    public void writeBooleanArray(boolean[] var1) throws IOException;

    public void writeCharArray(char[] var1) throws IOException;

    public void writeBigInteger(BigInteger var1) throws IOException;

    public void writeBigDecimal(BigDecimal var1) throws IOException;

    public void writeLocalTime(LocalTime var1) throws IOException;

    public void writeLocalDate(LocalDate var1) throws IOException;

    public void writeLocalDateTime(LocalDateTime var1) throws IOException;

    public void writeInstant(Instant var1) throws IOException;

    public void writePeriod(Period var1) throws IOException;

    public void writeDuration(Duration var1) throws IOException;

    public void writeUuid(UUID var1) throws IOException;

    public void writeBitSet(BitSet var1) throws IOException;

    public void flush() throws IOException;

    default public <T> void writeCollection(Collection<T> collection, ObjectWriter<T> elementWriter) throws IOException {
        this.writeVarInt(collection.size());
        for (T e : collection) {
            elementWriter.write(e, this);
        }
    }

    default public <K, V> void writeMap(Map<K, V> map, ObjectWriter<K> keyWriter, ObjectWriter<V> valWriter) throws IOException {
        this.writeVarInt(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            keyWriter.write(e.getKey(), this);
            valWriter.write(e.getValue(), this);
        }
    }

    @FunctionalInterface
    public static interface ObjectWriter<T> {
        public void write(T var1, IgniteDataOutput var2) throws IOException;
    }
}

