/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class IgniteStripedReadWriteLock
implements ReadWriteLock {
    private static final int CONCURRENCY = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    private static final AtomicInteger IDX_GEN = new AtomicInteger();
    private static final ThreadLocal<Integer> IDX = ThreadLocal.withInitial(() -> IDX_GEN.incrementAndGet());
    private final ReentrantReadWriteLock[] locks;
    private final WriteLock writeLock;

    public IgniteStripedReadWriteLock() {
        this(CONCURRENCY);
    }

    public IgniteStripedReadWriteLock(int concurrencyLvl) {
        this.locks = new ReentrantReadWriteLock[concurrencyLvl];
        for (int i = 0; i < concurrencyLvl; ++i) {
            this.locks[i] = new ReentrantReadWriteLock();
        }
        this.writeLock = new WriteLock();
    }

    private int curIdx() {
        int idx = IDX.get();
        return idx % this.locks.length;
    }

    @Override
    public Lock readLock() {
        return this.locks[this.curIdx()].readLock();
    }

    public Lock readLock(int idx) {
        return this.locks[idx].readLock();
    }

    @Override
    public Lock writeLock() {
        return this.writeLock;
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.locks[this.curIdx()].isWriteLockedByCurrentThread();
    }

    public int getReadHoldCount() {
        return this.locks[this.curIdx()].getReadHoldCount();
    }

    private class WriteLock
    implements Lock {
        private WriteLock() {
        }

        @Override
        public void lock() {
            block2: {
                try {
                    this.lock0(false);
                }
                catch (InterruptedException ignore) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)"Should never happen");
                }
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.lock0(true);
        }

        @Override
        public void unlock() {
            this.unlock0(IgniteStripedReadWriteLock.this.locks.length - 1);
        }

        private void lock0(boolean canInterrupt) throws InterruptedException {
            int i;
            try {
                for (i = 0; i < IgniteStripedReadWriteLock.this.locks.length; ++i) {
                    if (canInterrupt) {
                        IgniteStripedReadWriteLock.this.locks[i].writeLock().lockInterruptibly();
                        continue;
                    }
                    IgniteStripedReadWriteLock.this.locks[i].writeLock().lock();
                }
            }
            catch (InterruptedException e) {
                this.unlock0(i - 1);
                throw e;
            }
        }

        private void unlock0(int fromIdx) {
            for (int i = fromIdx; i >= 0; --i) {
                IgniteStripedReadWriteLock.this.locks[i].writeLock().unlock();
            }
        }

        @Override
        public boolean tryLock() {
            int i;
            try {
                for (i = 0; i < IgniteStripedReadWriteLock.this.locks.length; ++i) {
                    if (IgniteStripedReadWriteLock.this.locks[i].writeLock().tryLock()) continue;
                    break;
                }
            }
            finally {
                if (0 < i && i < IgniteStripedReadWriteLock.this.locks.length) {
                    this.unlock0(i - 1);
                }
            }
            return i == IgniteStripedReadWriteLock.this.locks.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            int i;
            long end = unit.toNanos(time) + System.nanoTime();
            try {
                for (i = 0; i < IgniteStripedReadWriteLock.this.locks.length && System.nanoTime() < end; ++i) {
                    if (IgniteStripedReadWriteLock.this.locks[i].writeLock().tryLock(time, unit)) continue;
                    break;
                }
            }
            finally {
                if (0 < i && i < IgniteStripedReadWriteLock.this.locks.length) {
                    this.unlock0(i - 1);
                }
            }
            return i == IgniteStripedReadWriteLock.this.locks.length;
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

