/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.util.BitSet;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;

public final class RowTypeUtils {
    public static RelDataType rowType(TableDescriptor tableDescriptor, IgniteTypeFactory factory) {
        return tableDescriptor.rowType(factory, RowTypeUtils.storedColumns(tableDescriptor));
    }

    public static int storedRowsCount(TableDescriptor tableDescriptor) {
        return RowTypeUtils.storedColumns(tableDescriptor).cardinality();
    }

    private static ImmutableBitSet storedColumns(TableDescriptor tableDescriptor) {
        ImmutableBitSet storedColumns;
        BitSet virtualColumns = new BitSet();
        for (ColumnDescriptor descriptor : tableDescriptor) {
            if (!descriptor.virtual()) continue;
            virtualColumns.set(descriptor.logicalIndex());
        }
        if (virtualColumns.isEmpty()) {
            storedColumns = ImmutableBitSet.range((int)tableDescriptor.columnsCount());
        } else {
            virtualColumns.flip(0, tableDescriptor.columnsCount());
            storedColumns = ImmutableBitSet.fromBitSet((BitSet)virtualColumns);
        }
        return storedColumns;
    }
}

