/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.mapping;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.sql.engine.exec.mapping.IdGenerator;
import org.apache.ignite.internal.sql.engine.prepare.Fragment;
import org.apache.ignite.internal.sql.engine.prepare.IgniteRelShuttle;
import org.apache.ignite.internal.sql.engine.rel.IgniteCorrelatedNestedLoopJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteExchange;
import org.apache.ignite.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteReceiver;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite.internal.sql.engine.rel.IgniteSystemViewScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTrimExchange;
import org.apache.ignite.internal.sql.engine.schema.IgniteSystemView;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.util.Commons;

class FragmentSplitter
extends IgniteRelShuttle {
    private final Deque<FragmentProto> stack = new LinkedList<FragmentProto>();
    private final IdGenerator idGenerator;
    private RelNode cutPoint;
    private FragmentProto curr;
    private boolean correlated = false;

    FragmentSplitter(IdGenerator idGenerator, RelNode cutPoint) {
        this.idGenerator = idGenerator;
        this.cutPoint = cutPoint;
    }

    public List<Fragment> go(Fragment fragment) {
        ArrayList<Fragment> res = new ArrayList<Fragment>();
        this.stack.push(new FragmentProto(fragment.fragmentId(), fragment.correlated(), fragment.root()));
        while (!this.stack.isEmpty()) {
            this.curr = this.stack.pop();
            this.correlated = this.curr.correlated;
            this.curr.root = this.visit(this.curr.root);
            res.add(this.curr.build());
            this.curr = null;
        }
        return res;
    }

    @Override
    public IgniteRel visit(IgniteSystemViewScan rel) {
        IgniteSystemView view = (IgniteSystemView)rel.getTable().unwrap(IgniteSystemView.class);
        assert (view != null);
        if (this.curr.seenRelations.add(view.id())) {
            this.curr.systemViews.add(view);
        }
        return super.visit(rel);
    }

    @Override
    public IgniteRel visit(IgniteTableScan rel) {
        IgniteTable table = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        assert (table != null);
        this.curr.tables.put(rel.sourceId(), (Object)table);
        return super.visit(rel);
    }

    @Override
    public IgniteRel visit(IgniteIndexScan rel) {
        IgniteTable table = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        assert (table != null);
        this.curr.tables.put(rel.sourceId(), (Object)table);
        return super.visit(rel);
    }

    @Override
    public IgniteRel visit(IgniteTableModify rel) {
        IgniteTable table = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        assert (table != null);
        this.curr.tables.put(rel.sourceId(), (Object)table);
        return super.visit(rel);
    }

    @Override
    public IgniteRel visit(IgniteReceiver rel) {
        this.curr.remotes.add(rel);
        return rel;
    }

    @Override
    public IgniteRel visit(IgniteExchange rel) {
        throw new AssertionError();
    }

    @Override
    public IgniteRel visit(IgniteCorrelatedNestedLoopJoin rel) {
        if (rel == this.cutPoint) {
            this.cutPoint = null;
            return this.split(rel);
        }
        List inputs = Commons.cast(rel.getInputs());
        assert (inputs.size() == 2);
        this.visitChild(rel, 0, (IgniteRel)inputs.get(0));
        boolean correlatedBefore = this.correlated;
        this.correlated = true;
        this.visitChild(rel, 1, (IgniteRel)inputs.get(1));
        this.correlated = correlatedBefore;
        return rel;
    }

    @Override
    protected IgniteRel processNode(IgniteRel rel) {
        if (rel == this.cutPoint) {
            this.cutPoint = null;
            return this.split(rel);
        }
        List inputs = Commons.cast(rel.getInputs());
        for (int i = 0; i < inputs.size(); ++i) {
            this.visitChild(rel, i, (IgniteRel)inputs.get(i));
        }
        return rel;
    }

    private IgniteRel split(IgniteRel rel) {
        long sourceFragmentId;
        RelOptCluster cluster = rel.getCluster();
        RelTraitSet traits = rel.getTraitSet();
        RelDataType rowType = rel.getRowType();
        IgniteRel input = rel instanceof IgniteTrimExchange ? rel.getInput(0) : rel;
        long targetFragmentId = this.curr.id;
        long exchangeId = sourceFragmentId = this.idGenerator.nextId();
        IgniteReceiver receiver = new IgniteReceiver(cluster, traits, rowType, exchangeId, sourceFragmentId);
        IgniteSender sender = new IgniteSender(cluster, traits, (RelNode)input, exchangeId, targetFragmentId, rel.distribution());
        this.curr.remotes.add(receiver);
        this.stack.push(new FragmentProto(sourceFragmentId, this.correlated, sender));
        return receiver;
    }

    private static class FragmentProto {
        private final long id;
        private final boolean correlated;
        private IgniteRel root;
        private final IntSet seenRelations = new IntOpenHashSet();
        private final List<IgniteReceiver> remotes = new ArrayList<IgniteReceiver>();
        private final Long2ObjectMap<IgniteTable> tables = new Long2ObjectArrayMap();
        private final List<IgniteSystemView> systemViews = new ArrayList<IgniteSystemView>();

        private FragmentProto(long id, boolean correlated, IgniteRel root) {
            this.id = id;
            this.correlated = correlated;
            this.root = root;
        }

        Fragment build() {
            return new Fragment(this.id, this.correlated, this.root, this.remotes, this.tables, this.systemViews);
        }
    }
}

