/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.Closure;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite.raft.jraft.rpc.RpcContext;

public class RpcRequestClosure
implements Closure {
    private static final IgniteLogger LOG = Loggers.forClass(RpcRequestClosure.class);
    private static final AtomicIntegerFieldUpdater<RpcRequestClosure> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RpcRequestClosure.class, "state");
    private static final int PENDING = 0;
    private static final int RESPOND = 1;
    private final RpcContext rpcCtx;
    private final RaftMessagesFactory msgFactory;
    private volatile int state = 0;

    public RpcRequestClosure(RpcContext rpcCtx, RaftMessagesFactory msgFactory) {
        this.rpcCtx = rpcCtx;
        this.msgFactory = msgFactory;
    }

    public RpcContext getRpcCtx() {
        return this.rpcCtx;
    }

    public RaftMessagesFactory getMsgFactory() {
        return this.msgFactory;
    }

    public void sendResponse(Message msg) {
        if (!STATE_UPDATER.compareAndSet(this, 0, 1)) {
            LOG.warn("A response: {} sent repeatedly!", new Object[]{msg});
            return;
        }
        this.rpcCtx.sendResponse(msg);
    }

    @Override
    public void run(Status status) {
        this.sendResponse(RaftRpcFactory.DEFAULT.newResponse(this.msgFactory, status));
    }
}

