/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.table;

import java.util.List;
import java.util.Objects;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.table.DataStreamerReceiver;
import org.jetbrains.annotations.Nullable;

public class ReceiverDescriptor<A> {
    private final String receiverClassName;
    private final List<DeploymentUnit> units;
    @Nullable
    private final Marshaller<A, byte[]> argumentMarshaller;

    private ReceiverDescriptor(String receiverClassName, List<DeploymentUnit> units, @Nullable Marshaller<A, byte[]> argumentMarshaller) {
        Objects.requireNonNull(receiverClassName);
        Objects.requireNonNull(units);
        this.receiverClassName = receiverClassName;
        this.units = units;
        this.argumentMarshaller = argumentMarshaller;
    }

    public String receiverClassName() {
        return this.receiverClassName;
    }

    public List<DeploymentUnit> units() {
        return this.units;
    }

    public static <A> Builder<A> builder(String receiverClassName) {
        Objects.requireNonNull(receiverClassName);
        return new Builder(receiverClassName);
    }

    public static <A> Builder<A> builder(Class<? extends DataStreamerReceiver<?, A, ?>> receiverClass) {
        Objects.requireNonNull(receiverClass);
        return new Builder(receiverClass.getName());
    }

    @Nullable
    public Marshaller<A, byte[]> argumentMarshaller() {
        return this.argumentMarshaller;
    }

    public static class Builder<A> {
        private final String receiverClassName;
        private List<DeploymentUnit> units;
        @Nullable
        private Marshaller<A, byte[]> argumentMarshaller;

        private Builder(String receiverClassName) {
            Objects.requireNonNull(receiverClassName);
            this.receiverClassName = receiverClassName;
        }

        public Builder<A> units(List<DeploymentUnit> units) {
            this.units = units;
            return this;
        }

        public Builder<A> units(DeploymentUnit ... units) {
            this.units = List.of(units);
            return this;
        }

        public Builder<A> argumentMarshaller(@Nullable Marshaller<A, byte[]> argumentsMarshaller) {
            this.argumentMarshaller = argumentsMarshaller;
            return this;
        }

        public ReceiverDescriptor<A> build() {
            return new ReceiverDescriptor<A>(this.receiverClassName, this.units == null ? List.of() : this.units, this.argumentMarshaller);
        }
    }
}

