/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.ChangePeersRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.CliRequests;

public class ChangePeersRequestImpl
implements CliRequests.ChangePeersRequest {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 1004;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final String leaderId;
    @IgniteToStringInclude
    private final Collection<String> newPeersList;

    private ChangePeersRequestImpl(String groupId, String leaderId, Collection<String> newPeersList) {
        this.groupId = groupId;
        this.leaderId = leaderId;
        this.newPeersList = newPeersList;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String leaderId() {
        return this.leaderId;
    }

    @Override
    public Collection<String> newPeersList() {
        return this.newPeersList;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(ChangePeersRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 1004;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ChangePeersRequestImpl otherMessage = (ChangePeersRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.leaderId, otherMessage.leaderId) && Objects.equals(this.newPeersList, otherMessage.newPeersList);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.groupId, this.leaderId, this.newPeersList);
        return result;
    }

    public static ChangePeersRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ChangePeersRequestBuilder {
        private String groupId;
        private String leaderId;
        private Collection<String> newPeersList;

        private Builder() {
        }

        @Override
        public ChangePeersRequestBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public ChangePeersRequestBuilder leaderId(String leaderId) {
            this.leaderId = leaderId;
            return this;
        }

        @Override
        public ChangePeersRequestBuilder newPeersList(Collection<String> newPeersList) {
            this.newPeersList = newPeersList;
            return this;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public String leaderId() {
            return this.leaderId;
        }

        @Override
        public Collection<String> newPeersList() {
            return this.newPeersList;
        }

        @Override
        public CliRequests.ChangePeersRequest build() {
            return new ChangePeersRequestImpl(this.groupId, this.leaderId, this.newPeersList);
        }
    }
}

