/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.ignite.internal.sql.engine.externalize.RelJsonWriter;
import org.apache.ignite.internal.sql.engine.metadata.ColocationMappingException;
import org.apache.ignite.internal.sql.engine.metadata.FragmentMapping;
import org.apache.ignite.internal.sql.engine.metadata.FragmentMappingException;
import org.apache.ignite.internal.sql.engine.metadata.IgniteMdFragmentMapping;
import org.apache.ignite.internal.sql.engine.metadata.MappingService;
import org.apache.ignite.internal.sql.engine.metadata.NodeMappingException;
import org.apache.ignite.internal.sql.engine.prepare.Cloner;
import org.apache.ignite.internal.sql.engine.prepare.MappingQueryContext;
import org.apache.ignite.internal.sql.engine.rel.IgniteReceiver;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Fragment {
    private final long id;
    private final IgniteRel root;
    @IgniteToStringExclude
    private final String rootSer;
    private final FragmentMapping mapping;
    private final List<IgniteReceiver> remotes;

    public Fragment(long id, IgniteRel root, List<IgniteReceiver> remotes) {
        this(id, root, remotes, null, null);
    }

    Fragment(long id, IgniteRel root, List<IgniteReceiver> remotes, @Nullable String rootSer, @Nullable FragmentMapping mapping) {
        this.id = id;
        this.root = root;
        this.remotes = List.copyOf(remotes);
        this.rootSer = rootSer != null ? rootSer : RelJsonWriter.toJson((RelNode)root);
        this.mapping = mapping;
    }

    public long fragmentId() {
        return this.id;
    }

    public IgniteRel root() {
        return this.root;
    }

    public String serialized() {
        return this.rootSer;
    }

    public FragmentMapping mapping() {
        return this.mapping;
    }

    private FragmentMapping mapping(MappingQueryContext ctx, RelMetadataQuery mq, Supplier<List<String>> nodesSource) {
        try {
            FragmentMapping mapping = IgniteMdFragmentMapping.fragmentMappingForMetadataQuery((RelNode)this.root, mq, ctx);
            if (this.rootFragment()) {
                mapping = FragmentMapping.create(ctx.localNodeId()).colocate(mapping);
            }
            if (this.single() && mapping.nodeIds().size() > 1) {
                mapping = FragmentMapping.create(mapping.nodeIds().get(ThreadLocalRandom.current().nextInt(mapping.nodeIds().size()))).colocate(mapping);
            }
            return mapping.finalize(nodesSource);
        }
        catch (NodeMappingException e) {
            throw new FragmentMappingException("Failed to calculate physical distribution", this, e.node(), e);
        }
        catch (ColocationMappingException e) {
            throw new FragmentMappingException("Failed to calculate physical distribution", this, (RelNode)this.root, e);
        }
    }

    public List<IgniteReceiver> remotes() {
        return this.remotes;
    }

    public boolean rootFragment() {
        return !(this.root instanceof IgniteSender);
    }

    public Fragment attach(RelOptCluster cluster) {
        return this.root.getCluster() == cluster ? this : new Cloner(cluster).go(this);
    }

    Fragment map(MappingService mappingSrvc, MappingQueryContext ctx, RelMetadataQuery mq) throws FragmentMappingException {
        if (this.mapping != null) {
            return this;
        }
        return new Fragment(this.id, this.root, this.remotes, this.rootSer, this.mapping(ctx, mq, this.nodesSource(mappingSrvc, ctx)));
    }

    @NotNull
    private Supplier<List<String>> nodesSource(MappingService mappingSrvc, MappingQueryContext ctx) {
        return () -> mappingSrvc.executionNodes(this.single(), null);
    }

    private boolean single() {
        return this.root instanceof IgniteSender && ((IgniteSender)this.root).sourceDistribution().satisfies((RelTrait)IgniteDistributions.single());
    }

    public String toString() {
        return S.toString(Fragment.class, (Object)this, (String)"root", (Object)RelOptUtil.toString((RelNode)this.root));
    }
}

